<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Model extends CI_Model {

    var $tableName = 'tbl_packages';
    var $tablePkgSpecification = 'tbl_pkg_specification';
    var $tablePkgCategory = 'tbl_package_category';
    var $tablePkgItems = 'tbl_package_items';

    function getPackageRecords($package_type='package',$online_cat_id=FALSE) {
         $this->db->where('package_type', $package_type);
         $location_id = $this->session->userdata('location_id');
         $this->db->where('province_id', $location_id);
         if($online_cat_id)
             $this->db->where('online_cat_id', $online_cat_id);
        $this->db->order_by('package_id', 'asc');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getPackageRecordsById($packageId) {
        $this->db->where('package_id', $packageId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getAllPackageCategory() {
        $query = $this->db->get($this->tablePkgCategory);
        $result = $query->result_array();
        return $result;
    }

    function getPackageSpecificationsByCategory($packageId, $category_id) {
        $this->db->where('package_id', $packageId);
        $this->db->where('category_id', $category_id);
        $this->db->where('is_active', 'yes');
        $this->db->order_by('item_id', 'asc');
        $query = $this->db->get($this->tablePkgSpecification);
        $result = $query->result_array();
        return $result;
    }
    function getPackageSpecificationsByCategoryPeople($packageId, $category_id, $no_of_people) {
        $this->db->where('package_id', $packageId);
        if($no_of_people>=100)
            $no_of_people=99;
        $this->db->where('category_id', $category_id);
        $this->db->where('min_people <=', $no_of_people);
        $this->db->where('is_active', 'yes');
        $this->db->order_by('item_id', 'asc');
        $query = $this->db->get($this->tablePkgSpecification);
     
        $result = $query->result_array(); 
        return $result;
    }
    function getSpecificationsbyPackageAndItem($packageId, $selected_package_items) {    
        $this->db->where('package_id', $packageId);
        $this->db->where('item_id', $selected_package_items);
        $this->db->where('is_active', 'yes');
        $query = $this->db->get($this->tablePkgSpecification);
        $result = $query->row_array();
        return $result;
    }

}