<?php

class Cart_Items_Model extends CI_Model {

    var $tablename = 'tbl_oo_cart_items';

    // var $tableOrderItem = 'tbl_order_item';
    public function addCartItems($cartItems) {

        $this->db->set('item_name', $cartItems['item_name']);
        $this->db->set('item_id', $cartItems['item_id']);
        $this->db->set('category_id', $cartItems['category_id']);
        $this->db->set('category_name', $cartItems['category_name']);
        $this->db->set('item_type', $cartItems['item_type']);
        $this->db->set('unit_price', $cartItems['unit_price']);
        $this->db->set('unit_name', $cartItems['unit_name']);
        $this->db->set('unit_id', $cartItems['unit_id']);
        $this->db->set('no_of_people', $cartItems['no_of_people']);
        $this->db->set('item_quantity', $cartItems['item_quantity']);
        $this->db->set('total_item_price', $cartItems['total_item_price']);
        if($cartItems['item_note'])
             $this->db->set('item_note', $cartItems['item_note']);
        if ($cartItems['cart_item_id']) {
            $this->db->where('cart_item_id', $cartItems['cart_item_id']);
            $this->db->where('session_id', $this->session->userdata('my_session_id'));
            $response = $this->db->update($this->tablename);
        } else {
            $this->db->set('session_id', $this->session->userdata('my_session_id'));
            $response = $this->db->insert($this->tablename);
        }
        return $response;
    }

    public function addCartPackage($cartItems) {
        if($cartItems['category_id']) {
        $this->db->set('category_id', $cartItems['category_id']);
        }
        if($cartItems['category_name']) {
        $this->db->set('category_name', $cartItems['category_name']);
        }
        $this->db->set('item_name', $cartItems['item_name']);
        $this->db->set('item_id', $cartItems['item_id']);
        $this->db->set('item_type', 'package');
        $this->db->set('unit_price', $cartItems['unit_price']);
        $this->db->set('no_of_people', $cartItems['no_of_people']);
        $this->db->set('item_quantity', $cartItems['item_quantity']);
        $this->db->set('total_item_price', $cartItems['total_item_price']);
        $this->db->set('session_id', $this->session->userdata('my_session_id'));
        $this->db->insert($this->tablename);
        $response = $this->db->insert_id();
        return $response;
    }

    public function addCartPackageItems($all_package_items, $cart_package_id) {
        foreach ($all_package_items as $package_items) {
            $this->db->set('cart_item_id', $cart_package_id);
            $this->db->set('session_id', $this->session->userdata('my_session_id'));
            $this->db->set('category_id', $package_items['category_id']);
            $this->db->set('item_id', $package_items['item_id']);
            $this->db->set('category_name', $this->common_model->getSingleFieldFromAnyTable('pkg_cat_name', 'pkg_cat_id', $package_items['category_id'], 'tbl_package_category'));
            if ($package_items['item_price']) {
                $this->db->set('item_price', $package_items['item_price']);
                $this->db->set('item_quantity', $package_items['item_quantity']);
                $this->db->set('total_item_price', $package_items['total_item_price']);
                $this->db->set('item_type', $package_items['item_type']);
                $this->db->set('item_name', $package_items['item_name']);
            } else {
                $this->db->set('item_price', '0');
                $this->db->set('item_type', 'default');
                $this->db->set('item_quantity', $package_items['item_quantity']);
                $this->db->set('total_item_price', '0');
                $this->db->set('item_name', $this->common_model->getSingleFieldFromAnyTable('item_name', 'pkg_item_id', $package_items['item_id'], 'tbl_package_items'));
            }
            $this->db->insert('tbl_cart_pkg_items');
        }
    }

    function getCountCartItems() {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->get($this->tablename);
        $result = $query->num_rows();
        return $result;
    }

    public function updateCartItem($cartItems) {
        $this->db->set('item_quantity', $cartItems['item_quantity']);
        $this->db->set('total_item_price', $cartItems['total_item_price']);
        if ($cartItems['cart_item_id']) {
            $this->db->where('cart_item_id', $cartItems['cart_item_id']);
            $this->db->where('session_id', $this->session->userdata('my_session_id'));
            $response = $this->db->update($this->tablename);
        }
        return $response;
    }

    function getCartItemsTotal() {
        $this->db->select_sum('total_item_price');
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->get($this->tablename);
        $result = $query->row_array();
        return $result;
    }

    function getCartItemDetail() {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->get($this->tablename);
        $result = $query->result_array();
        return $result;
    }

    function getCartPackageItemDetail($cart_item_id) {
        $this->db->where('cart_item_id', $cart_item_id);
        $query = $this->db->get('tbl_cart_pkg_items');
        $result = $query->result_array();
        return $result;
    }

    public function getCartItemByUnitAnditem($item_id, $unit_id=FALSE,$item_type=FALSE) {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $this->db->where('item_id', $item_id);
        if($unit_id)
        $this->db->where('unit_id', $unit_id);
        if($item_type)
        $this->db->where('item_type', $item_type);
        $query = $this->db->get($this->tablename);
        $result = $query->row_array();
        return $result;
    }

    public function getCartItemByCartItemId($cart_item_id) {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $this->db->where('cart_item_id', $cart_item_id);
        $query = $this->db->get($this->tablename);
        $result = $query->row_array();
        return $result;
    }

    function deleteCartItemByCartItemId($cart_item_id) {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $this->db->where('cart_item_id', $cart_item_id);
        $query = $this->db->delete($this->tablename);
        return $result;
    }

    function deleteCartPackageItemByCartItemId($cart_item_id) {
        $this->db->where('cart_item_id', $cart_item_id);
        $query = $this->db->delete('tbl_cart_pkg_items');
        return $result;
    }

    function emptyCartItems() {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->delete($this->tablename);
        return $result;
    }

    function emptyCartPackageItems($cart_item_id) {
        $this->db->where('cart_item_id', $cart_item_id);
        $query = $this->db->delete('tbl_cart_pkg_items');
        return $result;
    }
     function emptyCartPackageItemsBySession() {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->delete('tbl_cart_pkg_items');
        return $result;
    }

}
