<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Thanks extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('content_model', 'content');
        $this->load->model('online_order/cart_items_model', 'cart_items');
        $this->load->model('online_order/mailsending_model', 'mailsending');
        $this->load->model('province_model', 'province');
        $this->load->model('online_order/order_model', 'order');
        $this->load->library('Paypal_Lib');
    }

    public function index() {
        if ($this->session->userdata('order_id')) {
            $data['current_slug'] = $current_slug = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
            $data['orderId'] = $orderId = $this->session->userdata('order_id');
            $this->session->unset_userdata('order_id');
            $data['order_data'] = $this->order->orderDetailById($orderId);
            $data['order_items_data'] = $this->order->getOrderItems($orderId);
            $data['content_detail'] = $content_detail = $this->content->getContentRecordBySlug($current_slug);
            $data['METATITLE'] = $content_detail->meta_title . ' | ' . $this->config->item('site_title');
            $data['METAKEYWORDS'] = $content_detail->meta_keywords;
            $data['METADESCRIPTION'] = $content_detail->meta_description;
            $data['page_heading'] = $content_detail->page_heading;
            $data['page_content'] = $content_detail->page_content;
            $data['page_name'] = $content_detail->page_title;
            $this->load->view('online_order/header', $data);
            $this->load->view('online_order/thanks');
            $this->load->view('online_order/footer');
        } else {
            redirect('online-order');
            exit;
        }
    }

    public function paypal_failure() {
//  pr($_REQUEST);die;
        $data['orderId'] = $orderId = $this->session->userdata('order_id');
        $payment_data = array(
            'order_id' => $orderId,
            'payment_status' => 'unpaid',
            'order_status' => 'cancelled',
            'transaction_id' => $_REQUEST['txn_id'],
            'other_data' => json_encode($_REQUEST),
        );
        $this->order->updateOrderPaymentStatus($payment_data);
        $this->mailsending->orderMail($orderId);
        redirect('thanks-for-order');
        exit();
    }

    public function paypal_success() {
        $data['orderId'] = $orderId = $this->session->userdata('order_id');
        $payment_data = array(
            'order_id' => $orderId,
            'payment_status' => 'paid',
            'order_status' => 'pending',
            'transaction_id' => $_REQUEST['txn_id'],
            'other_data' => json_encode($_REQUEST),
        );
        $this->order->updateOrderPaymentStatus($payment_data);
        $this->mailsending->orderMail($orderId);
        redirect('thanks-for-order');
        exit();
    }

    public function validatePaypal() {
        // $this->paypal->paypal_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr&#8217'; // testing paypal url
        $this->paypal_lib->paypal_url = 'https://www.paypal.com/cgi-bin/webscr&#8217;'; // paypal url
        if ($this->paypal_lib->validate_ipn()) {
            $orderId = trim($_POST['custom']);
            $itemName = trim($_POST['item_name']);
        }
    }

}
