<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->common_model->checkOOCartItems();
        $this->load->model('online_order/order_model', 'order');
        $this->load->model('mailsending_model', 'mailsending');
        $this->load->model('online_order/cart_items_model', 'cart_items');
        $this->load->model('online_order/cart_model', 'cart');
        $this->load->library('Paypal_Lib');
    }

    public function index() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required');
            $this->form_validation->set_rules('time_notice', 'Time Notice', 'trim|required');
            // $this->form_validation->set_rules('address', 'Address', 'trim|required');
//            $this->form_validation->set_rules('delivery_date', 'Delivery Date', 'trim|required');
//            $this->form_validation->set_rules('delivery_time', 'Delivery Time', 'trim|required');
            if ($this->form_validation->run()) {
                $data['cart_data'] = $cart_data = $this->cart->getCartDetail();
                $data['cart_items_data'] = $cart_items_data = $this->cart_items->getCartItemDetail();
                if (!$cart_data || !$cart_items_data) {
                    redirect($_SERVER['HTTP_REFERER']);
                    exit;
                }
                $this->session->set_userdata($this->session->userdata('my_session_id'), $this->input->post());
                $this->load->view('online_order/header', $data);
                $this->load->view('online_order/order_confirmation');
                $this->load->view('online_order/footer');
            } else {
                $this->session->set_flashdata('order_submit_error', 'There is some error in form.');
                redirect($_SERVER['HTTP_REFERER']);
                exit;
            }
        } else {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
    }

    public function cancilOrder() {
        $this->cart->emptyCart();
        $this->cart_items->emptyCartItems();
        redirect('online-order');
        exit;
    }

    public function finalization() {
        $cart_data = $this->cart->getCartDetail();
        $cart_items_data = $this->cart_items->getCartItemDetail();
        $data['payment_type'] = $payment_type = $this->session->userdata($this->session->userdata('my_session_id'))['payment_type'];
        $data['total_amount'] = $total_amount = $cart_data['total_cart_price'];
        if ($cart_data && $cart_items_data && $this->session->userdata($this->session->userdata('my_session_id'))) {
            $order_id = $this->order->addConfirmedOrder($cart_data);
            foreach ($cart_items_data as $cart_items) {
                $order_item_id = $this->order->addOrderItems($order_id, $cart_items);
                if ($cart_items['item_type'] == 'package') {
                    $cart_package_items = $this->cart_items->getCartPackageItemDetail($cart_items['cart_item_id']);
                    $this->order->addOrderPackageItems($order_item_id, $cart_package_items);
                    $this->cart_items->emptyCartPackageItems($cart_items['cart_item_id']);
                }
            }
            $this->cart->emptyCart();
            $this->cart_items->emptyCartItems();
            $this->session->unset_userdata($this->session->userdata('my_session_id'));
            $this->session->set_userdata('order_id', $order_id);
            if ($payment_type == 'cash_on_delivery') {
                $this->mailsending->orderMail($order_id);
                redirect('online-order/thanks-for-order');
                exit();
            } else if ($payment_type == 'paypal') {
//              $this->paypal_class->paypal_url = 'https://www.sandbox.paypal.com/cgi- bin/webscr'; // testing paypal url
                $this->paypal_lib->paypal_url = 'https://www.paypal.com/cgi-bin/webscr'; // paypal url
                $this->paypal_lib->add_field('currency_code', 'CAD');
                $this->paypal_lib->add_field('business', $this->config->item('paypal_email'));
//              $this->paypal_class->add_field('business', $this->config->item('bussinessPayPalAccount'));
                $this->paypal_lib->add_field('return', site_url('online-order/payment-success')); // return url
                $this->paypal_lib->add_field('cancel_return', site_url('online-order/payment-failure')); // cancel url
                $this->paypal_lib->add_field('notify_url', site_url('online-order/validate-paypal')); // notify url
                // $totalPrice = $this->session->userdata('totalPrice');
                $this->paypal_lib->add_field('item_name', 'A1Sweets Online Order Id-' . $order_id);
                $this->paypal_lib->add_field('amount', $this->common_model->getSingleFieldFromAnyTable('total_amount', 'order_id', $order_id, 'tbl_order'));
                $this->paypal_lib->add_field('custom', $this->session->userdata('order_id'));
                redirect($this->paypal_lib->paypal_get_request_link());  // submit the fields to paypal
//              $p->dump_fields(); // for debugging, output a table of all the fields
                exit;
            }
        } else {
            redirect('online-order');
            exit;
        }
    }

    public function orderDetail($order_id) {
        $data['order_detail'] = $order_detail = $this->order->orderDetailById($order_id);
        $data['orderItems'] = $orderItems = $this->order->getOrderItems($order_detail->order_id);
        $this->load->view('online_order/header', $data);
        $this->load->view('online_order/order_detail');
        $this->load->view('online_order/footer');
    }

}
