<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Meals extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->common_model->checkUserLocation();
        $this->load->model('tray_category_model', 'trayCat');
        $this->load->model('tray_item_model', 'trayItem');
        $this->load->model('online_order/online_category_model', 'onlineCat');
        $this->load->model('online_order/package_model', 'package');
        $this->load->model('content_model', 'content');
        $this->load->model('area_model', 'area');
        $this->load->model('online_order/cart_items_model', 'cart_items');
        $this->load->model('province_model', 'province');
        $this->load->model('online_order/cart_model', 'cart');
    }

    public function index() {
    $data['online_category'] = $this->onlineCat->getOnlineCategorylist(0);
        $data['online_categories'] = $this->onlineCat->getOnlineCategorylist($this->session->userdata('location_id'));
        $data['category_detail']=$category_row = $this->common_model->getSingleRowFromAnyTable('slug', 'meals', $this->onlineCat->tableName);
        
        $data['category_id'] = $category_id = $category_row->online_cat_id;
        $this->session->unset_userdata('no_of_people');
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $this->package->configurePackage($no_of_people);
        }
        $data['breadcrumb'] = 'Meals';
        $data['page_name'] = 'Meals';
        $data['package_data'] = $this->package->getPackageRecords();
        $this->load->view('online_order/header', $data);
        $this->load->view('online_order/meal');
        $this->load->view('online_order/footer');
    }

    public function configurePackage($packageId) {
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $package_data = $this->package->getPackageRecordsById($packageId);
            $min_people = $package_data['min_order_amount'];

            if ($no_of_people >= $min_people && $no_of_people <= 100) {
                $this->session->set_userdata('no_of_people', $no_of_people);
                redirect(site_url('package-detail/' . $packageId . '/' . $no_of_people));
                exit;
            } else if ($no_of_people > 100) {
                $this->session->set_userdata('packageErrorMessage', 'For more info please email info@a1sweets.com');
                redirect(site_url('package'));
                exit;
            } else {
                $this->session->set_flashdata('errorMessage', 'You have entered less no of people for this package');
                redirect(site_url('package'));
                exit;
            }
        }
    }

    public function getMealsByCategory() {
     
        $cat_id = $this->input->post('cat_id');
        $data['meal_data'] = $this->package->getPackageRecords('meal', $cat_id);
        $result['meal_dropdown'] = $this->load->view($this->config->item('template') . '/meal_dropdown', $data, true);
        $result['meal_id'] = $data['meal_data'][0]['package_id'];

        echo json_encode($result);
        die;
    }

    public function getPackgeDetail($packageId, $no_of_people = '25') {
        //echo $packageId;die;
//        if ($no_of_people > 100) {
//            $this->session->set_userdata('packageErrorMessage', 'For more info please email info@a1sweets.com');
//            redirect(site_url('package'));
//            exit;
//        }
//        $min_people = $this->common_model->getSingleFieldFromAnyTable('min_order_amount', 'package_id', $packageId, 'tbl_packages');
//        if ($no_of_people < $min_people) {
//            redirect(site_url('package'));
//            exit;
//        } else {
        $data['breadcrumb'] = 'package';
        $data['page_name'] = 'package';
        $data['eraseCache'] = true;
        $data['no_of_people'] = $no_of_people;
        $data['online_categories'] = $this->onlineCat->getOnlineCategorylist($this->session->userdata('location_id'));
$data['online_category'] = $this->onlineCat->getOnlineCategorylist(0);
$data['category_detail']=$category_row = $this->common_model->getSingleRowFromAnyTable('slug', 'meals', $this->onlineCat->tableName);
        $this->session->set_userdata('no_of_people', $no_of_people);
        $data['package_detail'] = $this->package->getPackageRecordsById($packageId);
        $data['meal_data'] = $this->package->getPackageRecords('meal', $data['package_detail']['online_cat_id']);
        $data['pkg_category_data'] = $this->package->getAllPackageCategory();
        $this->load->view('online_order/header', $data);
        $this->load->view('online_order/meal_detail');
        $this->load->view('online_order/footer');
        //}
    }

}
