<?php
$cart_data = $this->cart->getCartDetail();
$cart_items_data = $this->cart_items->getCartItemDetail();
?>
<div class="Order_block sidebarCart">
    <h4 class="section_title">Your order <span class="fa fa-shopping-cart"><span class="badge"><?= count($cart_items_data); ?></span></span></h4>
    <div class="loader">
        <i class="fa fa-spinner fa-spin"></i>
        <ol>
            <?php
            if ($cart_items_data) {
                foreach ($cart_items_data as $cart_items) {
                    ?>
                    <li>
                        <h4>
                            <span>
                                <?php echo $cart_items['item_quantity'] ?>
                            </span>
                            <?php echo $cart_items['unit_name'] ?>&nbsp;<?php echo $cart_items['item_name'] ?>
                        </h4>
                        <div class="btn-group">
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm amount_decrease">-</a>
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm amount_increase">+</a>
                            <a href="javascript:;" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="btn btn-default btn-sm delete_item"><i class="fa fa-trash-o"></i></a>
                            <?php if ($cart_items['item_type'] == 'package') { ?>
                                <a href="<?= site_url('get-cart-package-items/' . $cart_items['cart_item_id']) ?>" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="fancybox fancybox.iframe btn btn-default btn-sm" ><i class="fa fa-eye"></i></a>
                            <?php } ?>
                        </div>
                        <span class="order_price">$ <?php echo number_format($cart_items['total_item_price'], 2, '.', '') ?></span>
                    </li>
                <?php } ?>

            <?php } else {
                ?>
                <li>
                    Cart is empty Right Now.
                </li>
            <?php } ?>
        </ol>
        <?php if ($cart_items_data) { ?>
            <div class="pricebox2">
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <td>Subtotal</td>
                            <td align="right">$ <?php echo number_format($cart_data['sub_total'], 2, '.', '') ?></td>
                        </tr>
                        <?php if ($cart_data['gst_per'] != '0' && $cart_data['gst_per'] != '0.00') { ?>
                            <tr>
                                <td>GST (<?= $cart_data['gst_per'] ?>%)</td>
                                <td align="right">$ <?php echo number_format($cart_data['gst'], 2, '.', '') ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($cart_data['hst_per'] != '0' && $cart_data['hst_per'] != '0.00') { ?>
                            <tr>
                                <td>HST (<?= $cart_data['hst_per'] ?>%)</td>
                                <td align="right">$ <?php echo number_format($cart_data['hst'], 2, '.', '') ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($cart_data['pst_per'] != '0' && $cart_data['pst_per'] != '0.00') { ?>
                            <tr>
                                <td>PST (<?= $cart_data['pst_per'] ?>%)</td>
                                <td align="right">$ <?php echo number_format($cart_data['pst'], 2, '.', '') ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($cart_data['delivery_charges'] != '0' && $cart_data['delivery_charges'] != '0.00') { ?>
                            <tr>
                                <td>Delivery Charges</td>
                                <td align="right">$ <?php echo number_format($cart_data['delivery_charges'], 2, '.', '') ?></td>
                            </tr>
                        <?php } ?>
                        <?php if ($cart_data['discount'] != '0' && $cart_data['discount'] != '0.00') { ?>
                            <tr>
                                <td>Discount</td>
                                <td align="right">$ <?php echo number_format($cart_data['discount'], 2, '.', '') ?></td>
                            </tr>
                        <?php } ?>    
                        <tr>
                            <td>Total</td>
                            <td align="right">$ <?php echo number_format($cart_data['total_cart_price'], 2, '.', '') ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        <?php } ?>
    </div>
    <?php if ($page_name == 'checkout') { ?>
        <a href="<?= site_url('order-by-tray') ?>" class="btn btn-primary">Continue Shopping</a>
    <?php } else { ?>
        <?php if ($cart_items_data && $cart_data) { ?>
            <form role="form" class="coupon_form" method="post" action="<?= site_url('apply-coupon') ?>">
                <div class="input-group">
                    <input type="text" class="form-control" required placeholder="Coupon Code" name='coupon_code'>
                    <span class="input-group-btn">
                        <input type='submit' class="btn btn-primary" name='apply_coupon' value='apply'>
                    </span>
                </div>
            </form>
        <?php } ?>
    </div>
    <a href="<?= site_url('cancel-order') ?>" class="btn btn-primary">Empty Cart</a>
    <a href="<?= site_url('checkout') ?>" class="btn btn-primary">Checkout</a>
<?php } ?>