<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1><?= ucfirst($page_heading) ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?= ucfirst($page_heading) ?></li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <h2 class="section-heading"><?php echo ucfirst($page_heading) ?></h2>
        <div class="row">
            <div class="col-md-8">
                <dl id="menu_accordion">
                    <?php
                    foreach ($menu_category as $menuCat) {
                        $menu_item = $this->menuItem->getMenuItemByCatId($menuCat['item_cat_id']);
                        ?>
                        <dt><?php echo $menuCat['item_cat_name'] ?> <span class="pull-right">Price</span></dt>
                        <dd>
                            <ul class="meu_list">
                                <?php
                                foreach ($menu_item as $item) {
                                    $item_price = $item['item_price'];
                                    $unit_data = $this->menuItem->getUnitDataByItemId($item['item_id']);
                                    ?>                              
                                    <li>
                                        <?= $item['item_name']; ?> 
                                        <?php
                                        $price_string = '';
                                        if ($unit_data) {
                                            foreach ($unit_data as $unit) {
                                                $price_string.=$unit->unit_name . ' $' . $unit->unit_prices . ' | ';
                                            }
                                       } else {
                                        $price_string = '$'.number_format($item_price, 2, '.', '');
                                        }
                                        ?>
                                           <span><?php echo trim($price_string, '| '); ?></span>
                                        <!--     <span>$ <?php echo number_format($item_price, 2, '.', '');?></span>-->
                                        <?= $item['item_description'] ?></li>
                                <?php } ?>
                            </ul>
                        </dd>                    
                    <?php } ?>                   
                </dl>
            </div>
            <?php echo $this->load->view($this->config->item('template') . '/menu_rightbar'); ?>  
        </div>
    </div>
</section>