<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>
            <?php
            $current_url = current_url();
            //echo $current_url;die;
            $meta_tags = $this->common_model->getMetaTitle($current_url);
            if ($meta_tags) {
                $METATITLE = $meta_tags['metatag_title'];
                $METAKEYWORDS = $meta_tags['metatag_keyword'];
                $METADESCRIPTION = $meta_tags['metatag_description'];
                $HEADERIMAGE = $meta_tags['banner_image'];
                $BACKGROUNDIMAGE = $meta_tags['background_image'];
            }
            if ($METATITLE) {
                echo $METATITLE;
            } else {
                echo $this->config->item('site_title');
            }
            ?></title>
        <?php if ($METAKEYWORDS) { ?>
            <meta name="keywords" content="<?php echo $METAKEYWORDS ?>" />
        <?php } else { ?>
            <meta name="keywords" content="<?php echo $this->config->item('meta_keywords'); ?>" />
        <?php } ?>
        <?php if ($METADESCRIPTION) { ?>
            <meta name="description" content="<?php echo $METADESCRIPTION ?>" />
        <?php } else { ?>
            <meta name="description" content="<?php echo $this->config->item('meta_description'); ?>" />
        <?php } ?>
        <meta http-equiv="Cache-control" content="no-cache">
        <meta http-equiv="Expires" content="-1">
        <link href="<?= $this->config->item('frontassets') ?>css/bootstrap.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/font-awesome.min.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/bootstrap-theme.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/style.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/datetimepicker.css" rel="stylesheet">

        <script src="<?= $this->config->item('frontassets') ?>js/jquery.min.js"></script>
        <script src="<?= $this->config->item('frontassets') ?>js/bootstrap.min.js"></script>
        <script src="<?= $this->config->item('frontassets') ?>js/jquery-ui.js"></script>
        <script src="<?= $this->config->item('frontassets') ?>js/carousal.js"></script>
        <script src="<?= $this->config->item('frontassets') ?>js/jquery.fancybox.js"></script>      
        <script src="<?= $this->config->item('frontassets') ?>js/bootstrap-datetimepicker.min.js"></script>
        <script src="<?= $this->config->item('frontassets') ?>js/script.js"></script>
        <!--[if lt IE 9]>
          <script src="js/html5shiv.min.js"></script>
          <script src="js/respond.min.js"></script>
        <![endif]-->
        <script>
            var baseurl = '<?= base_url() ?>';
        </script>
        
    </head>
    <body>
        <nav class="navbar navbar-default">
            <div class="container1">
                <!-- Brand and toggle get grouped for better mobile display -->
                <div class="col-xs-12 col-md-3">
                    <div class="navbar-header">
                        <a class="navbar-brand" href="<?= site_url() ?>"><img src="<?= $this->config->item('uploads') ?>site_images/<?= $this->config->item('logo') ?>" alt="<?= $this->config->item('site_title') ?>"></a>
                    </div>
                </div>            
                <div class="col-xs-12 col-md-9">
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navigation">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <div id="navigation" class="collapse navbar-collapse">
                        <ul class="nav navbar-nav">
                            <li class="<?php echo isset($page_name) && $page_name == 'home' ? 'active' : '' ?>"><a href="<?= site_url() ?>">Home</a></li>
                            <?php
                            $header_links = $this->common_model->getHeaderLinks();
                            foreach ($header_links as $header) {
                                ?>               
                                <li class="<?php echo $header['link_url'] == $page_name ? 'active' : '' ?>"><a href="<?= site_url() ?><?= $header['link_url'] ?>"><?= $header['link_title'] ?></a></li>   
                            <?php } ?> 
                        </ul>
                    </div>
                    <a href="<?= site_url('cart') ?>" class="btn cartbtn">
                        <?php $cart_items_data = $this->cart_items->getCartItemDetail(); ?> 
                        <i class="fa fa-shopping-cart"></i> View Cart <span id="header_cart_count" class="badge"><?= count($cart_items_data) ?></span>
                    </a>
                    <select class="btn btn-default change_location"> 
                        <option>Select Location</option>
                        <?php
                        $all_locations = $this->common_model->getAllLocation();
                        foreach ($all_locations as $locations) {
                            ?>
                            <option value="<?= $locations['province_id'] ?>" <?php echo ($locations['province_id'] == $this->session->userdata('location_id')) ? 'selected' : '' ?>><?= $locations['province_name'] ?></option>
                        <?php } ?>               
                    </select>
                </div>
            </div>
        </nav>