<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1><?php echo $page_heading ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo trim($breadcumb, '/ ') ?></li>
        </ol>
    </div>
</section>
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <?php if ($category_id) { ?>
            <div class="row">
                <?php
                $i = 0;
                foreach ($tray_item_list as $tray_item) {
                    ?>
                    <div class="device_full col-xs-12 col-sm-6 col-md-3">
                        <div class="menubox ourmenu">
                            <div class="menu_img">
                                <img src="<?= $this->config->item('uploads') ?>tray_item_images/<?= $tray_item['item_image'] ?>" alt="" class="img-responsive">
                                <h3><?= $tray_item['item_name'] ?></h3>
                                <a href="<?= site_url('order-by-tray-item/' . $tray_item['slug']) ?>">
                                    <figcaption>
                                        <div class="read-m btn btn-default-white">
                                            <i class="fa fa-file-text-o"></i>
                                            Order Now
                                        </div>
                                    </figcaption>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php } ?>

            </div>
        <?php } else { ?>
            <div class="row">
                <div class="col-md-8">
                    <div class="col-md-4">
                        <ul class="sidenav">
                            <?php foreach ($tray_item_list as $tray_item) { ?>
                                <li class="<?php echo($item_name == $tray_item['item_name'] ? 'active' : '') ?>"><a href="<?= site_url('order-by-tray-item/' . $tray_item['slug']) ?>"><?= $tray_item['item_name'] ?></a></li>
                            <?php } ?>
                        </ul>
                        <a href="<?= site_url('order-by-tray') ?>" class="btn btn-link back-btn"><i class="fa fa-angle-left"></i> Back to Menu</a>
                    </div>
                    <div class="col-md-8">
                        <div class="order-tablebox">
                            <form method="POST" class="catering_form">
                                <input type="button" value="Add to Cart" class="btn btn-primary pull-right add_item_to_cart" disabled id="uaddToCart">
                                <table class="order-table">
                                    <thead>
                                        <tr>                            
                                            <th colspan="2"><i class="fa fa-group"></i> No of People</th>
                                            <th><i class="fa fa-money"></i> Cost</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <input type="hidden" name="item_id" id="itemId" value="<?= $item_id ?>">
                                    <?php
                                    $i = 1;
                                    foreach ($unit_data as $unit) {
                                        ?>
                                        <tr>
                                            <td width="20"><input type="checkbox" class="item_size" name="unit_id[<?= $i ?>]" value="<?= $unit->unit_id ?>"></td>
                                            <td><?= $unit->unit_name ?></td>
                                            <td  data-default-price="<?= $unit->unit_prices ?>" class="total_item_price">$ <?= $unit->unit_prices ?></td>
                                        </tr>
                                        <?php
                                        $i++;
                                    }
                                    ?>
                                    </tbody> 
                                    <tfoot>
                                        <tr>
                                            <td colspan="2"><a href="<?= site_url('order-by-tray') ?>" class="btn btn-link back-btn"><i class="fa fa-angle-left"></i> Back to Menu</a></td>
                                            <td>                                            
                                                <input type="button" value="Add to Cart" class="btn btn-primary pull-right add_item_to_cart" disabled id="laddToCart">
                                            </td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 sidebarCart">
                    <?= $this->load->view($this->config->item('template') . '/sidebar_cart'); ?>
                </div>
            </div>
        <?php } ?>
    </div>
</section>
<script src="<?= $this->config->item('frontassets') ?>js/catering.js"></script>
<script>
    $(document).ready(function () {
        $(".optiontab").click(function () {
            $("#optioncheck").slideToggle(1000);
        });
    });
</script>
<script>
    $("body").delegate(".item_size", "click", function () {
        var checked_items = $(this).parent().parent().parent().parent().find('input.item_size:checked').length;
        if (checked_items > 0) {
            $('.add_item_to_cart').prop("disabled", false);
        } else {
            $('.add_item_to_cart').prop("disabled", true);
        }
    });
</script>
<?php if ($this->session->flashdata('cart_coupon_messages')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('cart_coupon_messages') ?>");
    </script>
<?php } ?>