<section class="page-heading">
    <div class="container">
        <h1><?php echo $page_heading ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo trim($breadcumb, '/ ') ?></li>
        </ol>
    </div>
</section>
<section class="MainContent">
    <div class="container">
        <h2 class="section-heading"><?php echo $page_heading ?>
            <select class="btn btn-default change_location" disabled>
                <option>Select Location</option>
                <?php
                $all_locations = $this->common_model->getAllLocation();
                foreach ($all_locations as $locations) {
                    ?>
                    <option value="<?= $locations['province_id'] ?>" 
                            <?php echo ($locations['province_id'] == $this->session->userdata('location_id')) ? 'selected' : '' ?>>
                                <?= $locations['province_name'] ?>
                    </option>
                <?php } ?>
            </select>
        </h2>
        <div class="row">
            <div class="col-md-9"> 
                <ul class="sidenav col-md-3">
                    <?php
                    $tray_cat = $this->trayCat->getTrayCategorylist();
                    foreach ($tray_cat as $tray) {
                        $current_slug = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
                        $category_name = $this->common_model->getSingleFieldFromAnyTable('tray_cat_name', 'slug', $current_slug, 'tbl_tray_category');
                        ?>
                        <li class="<?php echo($category_name == $tray['tray_cat_name'] ? 'active' : '') ?>"><a href="<?= site_url('order-by-tray/' . $tray['slug']) ?>"><?= $tray['tray_cat_name'] ?></a></li>
                    <?php } ?>
                </ul>
                <ul class="media-list dishlist col-md-9">
                    <?php
                    foreach ($tray_item_list as $tray_item) {
                        $unit_data = $this->trayItem->getUnitsByTrayItemId($tray_item['tray_item_id']);
                        ?>
                        <li class="media">
                            <div class="media-left">
                                <img alt="<?= $tray_item['item_name'] ?>" src="<?= $this->config->item('uploads') ?>tray_item_images/<?= $tray_item['item_image'] ?>" class="media-object">
                            </div>
                            <div class="media-body">
                                <h4 class="media-heading"><?= $tray_item['item_name'] ?></h4>
                                <?= $tray_item['item_description'] ?>
                                <div class="clearfix"></div>
                                <form method="POST" class="catering_form">
                                    <input type="hidden" name="item_id" value="<?= $tray_item['tray_item_id'] ?>">
                                    <table class="table">
                                        <tbody>
                                            <?php
                                            foreach ($unit_data as $unit) {
                                                ?>
                                                <tr>
                                                    <td width="120">
                                                        <label>                                                           
                                                            <input class="item_size" type="checkbox" name="unit_id[]" value="<?= $unit->unit_id ?>"> <?= $unit->unit_name ?>                                                          
                                                        </label>
                                                    </td>
                                                    <td width="120"><?= $unit->no_of_people ?></td>
                                                    <td width="50" data-default-price="<?= $unit->unit_prices ?>" class="total_item_price">$ <?= $unit->unit_prices ?></td>
                                                    <td width="100">
                                                        <div class="input-group">
                                                            <span class="input-group-btn">
                                                                <button class="btn btn-default amount_decrement" disabled type="button">-</button>
                                                            </span>
                                                            <input type="text" name="quantity[]" class="form-control quantity" disabled value="<?= $unit->default_value ?>">
                                                            <span class="input-group-btn">
                                                                <button class="btn btn-default amount_increment" disabled type="button">+</button>
                                                            </span>
                                                        </div>
                                                    </td>     
                                                </tr>  
                                            <?php } ?>
                                        </tbody>
                                    </table>                               
                                    <input type="button" value="Add to Cart" data-attr-item-id="<?= $tray_item['tray_item_id'] ?>" class="btn btn-primary pull-right add_item_to_cart" disabled id="addToCart">
                                </form>
                            </div>
                        </li>
                    <?php } ?>     
                </ul>
            </div>
            <div class="col-md-3 sidebarCart">
                <?= $this->load->view($this->config->item('template') . '/sidebar_cart'); ?>
            </div>
        </div>
    </div>
</section>
<script src="<?= $this->config->item('frontassets') ?>js/catering.js"></script>
<script>
    $(document).ready(function () {
        $(".optiontab").click(function(){
            $("#optioncheck").slideToggle(1000);
        });
    });
</script>
<script>
    $("body").delegate(".item_size", "click", function () {
        var checked_items = $(this).parent().parent().parent().parent().find('input.item_size:checked').length;
        if ($(this).is(':checked')) {
            $(this).parent().parent().parent().find('.quantity').prop("disabled", false);
            $(this).parent().parent().parent().find('.amount_increment').prop("disabled", false);
            $(this).parent().parent().parent().find('.amount_decrement').prop("disabled", false);
        }
        else {
            $(this).parent().parent().parent().find('.quantity').prop("disabled", true);
            $(this).parent().parent().parent().find('.amount_increment').prop("disabled", true);
            $(this).parent().parent().parent().find('.amount_decrement').prop("disabled", true);
        }
        if (checked_items > 0) {
            $(this).parent().parent().parent().parent().parent().parent().find('#addToCart').prop("disabled", false);
        } else {
            $(this).parent().parent().parent().parent().parent().parent().find('#addToCart').prop("disabled", true);
        }
    });

    $("body").delegate(".amount_decrement", "click", function () {
        //e.preventDefault();   
        var price = $(this).parent().parent().parent().parent().find('.total_item_price').attr('data-default-price');
        var quantity = $(this).parent().parent().find('.quantity').val();
        var new_quantity = parseInt(quantity) - parseInt(1);
        var total_price = parseFloat((parseFloat(price) * parseInt(new_quantity)));
        if (parseFloat(new_quantity) > 0 && !$(this).parent().parent().find('.quantity').prop('disabled')) {
            $(this).parent().parent().find('.quantity').val(parseFloat(parseFloat(new_quantity)));
            $(this).parent().parent().parent().parent().find('.total_item_price').text('$' + parseFloat(total_price).toFixed(2));
        }
    });

    $("body").delegate(".amount_increment", "click", function () {
        //e.preventDefault();   
        var price = $(this).parent().parent().parent().parent().find('.total_item_price').attr('data-default-price');
        var quantity = $(this).parent().parent().find('.quantity').val();
        var new_quantity = parseInt(quantity) + parseInt(1);
        var total_price = parseFloat((parseFloat(price) * parseInt(new_quantity)));
        if (!$(this).parent().parent().find('.quantity').prop('disabled')) {
            $(this).parent().parent().find('.quantity').val(parseFloat(parseFloat(new_quantity)));
            $(this).parent().parent().parent().parent().find('.total_item_price').text('$' + parseFloat(total_price).toFixed(2));
        }
    });
</script>
<?php if ($this->session->flashdata('cart_coupon_messages')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('cart_coupon_messages') ?>");
    </script>
<?php } ?>