<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Blog</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active">Blog</li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <h2 class="section-heading">Our Blog</h2>
        <div class="row">
            <div class="col-md-9">  
                <?php
                foreach ($blog_data as $blog) {
                    $blogCommentdata = $this->blog->getBlogCommentList($blog['blog_id']);
                    $file_path = FCPATH . "assets/uploads/blog_images/" . $blog['blog_image'];
                    ?>  
                    <article class="blog_row">
                        <?php if ($blog['blog_image'] != '' && file_exists($file_path)) { ?>
                            <a href="<?= site_url($blog['slug']) ?>" class="pull-left"><img src="<?= $this->config->item('uploads') ?>blog_images/<?= $blog['blog_image'] ?>" class="img-responsive" /></a> 
                        <?php } ?>
                        <div class="blog-desc">
                            <h4><a href="<?= site_url() ?>blog/<?= $blog['slug'] ?>"><?= $blog['blog_title'] ?></a></h4>
                            <h6>Posted On <i class="fa fa-calendar"></i> <?= date('d  M, Y', $blog['add_time']) ?> <i class="fa fa-user"></i> By <?= $blog['added_by'] ?>
                                <i class="fa fa-tag"></i> On <a href="<?= site_url() ?>blog/<?= $blog['slug'] ?>">Blog</a>
                                <a href="<?= site_url() ?>blog/<?= $blog['slug'] ?>"><i class="fa fa-comment"></i> <?php echo count($blogCommentdata) ?> Comments</a>
                            </h6>
                            <?= $this->common_model->showLimitedText($blog['blog_description'], 300) ?> <br>
                            <div class="text-right">
                                <a class="btn btn-default btn-sm" href="<?= site_url() ?>blog/<?= $blog['slug'] ?>">Learn More</a>
                            </div>
                        </div>
                    </article>
                <?php } ?>
            </div>
            <?php echo $this->load->view($this->config->item('template') . '/blog_widget'); ?>  
        </div>
</section>