<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('TemplateSuccess')) { ?>  
                    <div class="alert alert-info"> <?= $this->session->flashdata('TemplateSuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Email Template</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>                                        
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/email-template-add"><span class="fa fa-plus-square"></span>Add New</a></li>
                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Email Template Title</th>
                                    <th>Email Template Subject</th>
                                    <th>Sender From Email</th>
                                    <th>Sender To Email</th>
                                    <th>Status</th>
                                    <th>Action</th> 
                                </tr>
                            </thead>
                            <tbody>   
                                <?php                           
                                    foreach ($template_data as $template) {
                                        ?>
                                        <tr id="trow">
                                            <td><strong><?php echo (isset($template['email_template_title'])) ? $template['email_template_title'] : '-'; ?></strong></td>                                                   
                                            <td><?php echo (isset($template['email_subject'])) ? $template['email_subject'] : '-'; ?></td>
                                            <td><?php echo (isset($template['sender_from_email'])) ? $template['sender_from_email'] : '-'; ?></td>
                                            <td><?php echo (isset($template['sender_to_email'])) ? $template['sender_to_email'] : '-'; ?></td>
                                            <td><?php echo (isset($template['status'])) && $template['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                            <td>
                                                <?php echo anchor(base_url() . 'admin/email-template-edit/' . $template['template_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       

                                                <?php if ($template['status'] == 'active') { ?>
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/email-template-status/' . $template['template_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                                <?php } else { ?>    
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/email-template-status/' . $template['template_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                                <?php } ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/email-template-delete/' . $template['template_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>

                                            </td> 
                                        </tr>    
                                 <?php } ?>   
                            </tbody>
                        </table>
                    </div>                                

                </div>
            </div>                                                

        </div>
    </div>
</div>
