<?php

class Tray_Item_Model extends CI_Model {

    var $tableName = 'tbl_tray_item';
    var $tableTrayUnits = 'tbl_tray_units';

    public function getTrayItemByCatId($cat_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $this->db->where($this->tableName . '.category_id', $cat_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

//    public function getTrayItemByCatId($cat_id,$per_page,$currentpage) {
//        $this->db->where($this->tableName . '.status', 'active');       
//        $where = "FIND_IN_SET('".$cat_id."', tbl_tray_item.category_id)";  
//        $this->db->where( $where );    
//        $query = $this->db->get($this->tableName,$per_page,$currentpage);
//        $result = $query->result_array();  
//     // echo  $this->db->last_query();die;
//        return $result;
//    }
    public function getCountTrayItemByCatId($cat_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $where = "FIND_IN_SET('" . $cat_id . "', tbl_tray_item.category_id)";
        $this->db->where($where);
        $query = $this->db->get($this->tableName);
        $result = $query->num_rows();
        return $result;
    }

    public function getTrayItemByItemId($tray_item_id) {
        // $this->db->where($this->tableName . '.status', 'active');       
        $this->db->where($this->tableName . '.tray_item_id', $tray_item_id);
        //  $where = "FIND_IN_SET('".$cat_id."', tbl_tray_item.category_id)";   
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        // echo  $this->db->last_query();die;
        return $result;
    }

    public function getTrayItemByMatrixAndId($tray_item_id, $matrix_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $where = "FIND_IN_SET('" . $matrix_id . "', tbl_tray_item.tray_matrix)";
        $this->db->where($where);
        $this->db->where($this->tableName . '.tray_item_id', $tray_item_id);
        //  $where = "FIND_IN_SET('".$cat_id."', tbl_tray_item.category_id)";   
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        // echo  $this->db->last_query();die;
        return $result;
    }

    public function getAllTrayItems() {
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    public function getUnitsByTrayItemId($trayItemId) {
        $this->db->where($this->tableTrayUnits . '.is_active', 'yes');
        $this->db->where($this->tableTrayUnits . '.tray_item_id', $trayItemId);
        $query = $this->db->get($this->tableTrayUnits);
        $result = $query->result();
        return $result;
    }

    public function getUnitPricesById($unit_id) {
        //$this->db->select($this->tableTrayUnits.'unit_prices');
        $this->db->where($this->tableTrayUnits . '.is_active', 'yes');
        $this->db->where($this->tableTrayUnits . '.unit_id', $unit_id);
        $query = $this->db->get($this->tableTrayUnits);
        $result = $query->row();
        return $result;
    }

}
