<?php

class Menu_Item_Model extends CI_Model {

    var $tableName = 'tbl_menu_item';    
    var $tableTray = 'tbl_tray_item'; 
    var $tableMenuUnit = 'tbl_menu_units'; 
    
    
    public function getMenuItemByCatId($category_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $this->db->where($this->tableName . '.category_id', $category_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }
    
    public function getUnitDataByItemId($item_id) {
        $this->db->where($this->tableMenuUnit . '.is_active', 'yes');
        $this->db->where($this->tableMenuUnit . '.menu_item_id', $item_id);
        $query = $this->db->get($this->tableMenuUnit);
        $result = $query->result();
        return $result;
    }
    
    public function getItemByCatId($category_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $this->db->where($this->tableName . '.category_id', $category_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result();
        return $result;
    }
    
    public function getTrayItemByCatId($category_id) {
        $this->db->where($this->tableTray . '.status', 'active');
        $this->db->where($this->tableTray . '.tray_category_id', $category_id);
        $query = $this->db->get($this->tableTray);
        $result = $query->result();
        return $result;
    }
    
   
    
    public function getItemBySpecifications($categoryId,$itemOption) {
        $this->db->where($this->tablename . '.status', 'active');
        $this->db->where($this->tablename . '.category_id', $categoryId);
        $this->db->where($this->tablename . '.item_option', $itemOption);
        $query = $this->db->get($this->tablename);
        $result = $query->result();
        return $result;
    }
    
    public function getItemRecordByCatSlug($slug) {
        $this->db->where($this->tablename . '.status', 'active');
        $this->db->where($this->tablename . '.slug', $slug);
        $query = $this->db->get($this->tablename);
        $result = $query->row();
        return $result;
    }
public function getTrayItemRecordBySlug($slug) {
        $this->db->where($this->tableTray . '.status', 'active');
        $this->db->where($this->tableTray . '.slug', $slug);
        $query = $this->db->get($this->tablename);
        $result = $query->row();
        return $result;
    }
    function getItemPricelist($item_id = '') {
        $this->db->select('*');
	$this->db->where('price_is_active', 'active');
        $this->db->from($this->itemPricesTableName);
        if ($item_id != '')
            $this->db->where($this->itemPricesTableName . '.item_ID', $item_id);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    function getTrayItemPricelist($item_id = '') {
        $this->db->select('*');
	$this->db->where('price_is_active', 'active');
        $this->db->from($this->itemTrayPrices);
        if ($item_id != '')
            $this->db->where($this->itemTrayPrices . '.tray_item_Id', $item_id);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    function getItemPriceById($item_id) {
        $this->db->from($this->itemPricesTableName);
        $this->db->where($this->itemPricesTableName . '.item_price_id', $item_id);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }
     function getTrayItemPriceById($item_id) {
        $this->db->from($this->itemTrayPrices);
        $this->db->where($this->itemTrayPrices . '.tray_item_price_id', $item_id);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }
    function getItemDetailById($item_id) {
        $this->db->from($this->tablename);
        $this->db->where($this->tablename . '.item_id', $item_id);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }
     function getTrayItemDetailById($item_id) {
        $this->db->from($this->tableTray);
        $this->db->where($this->tableTray . '.tray_item_id', $item_id);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }

}