<?php

class Mailsending_Model extends CI_Model {

    function __construct() {
        $this->from = "";
        $this->mailtype = 'html';
        $this->sitelogo = base_url() . 'assets/email_template_images/logo.png';
        $this->background = base_url() . "assets/email_template_images/body-bg.png";
        $this->load->model('order_model', 'order');
    }

    function templatechoose($id) {
        $this->db->where('tbl_email_template.template_id', $id);
        $this->db->where('tbl_email_template.status', 'Active');
        $query = $this->db->get('tbl_email_template');
        $result = $query->row();
        return $result;
    }

    function orderMail($order_id) {
        $order_detail = $this->common_model->getSingleRowFromAnyTable('order_id', $order_id, 'tbl_order');
        $delivery_location_detail = $this->common_model->getSingleRowFromAnyTable('province_id', $order_detail->delivery_location_id, 'tbl_province');
        $order_items = $this->order->getOrderItems($order_id);
        $items.= '<table width="100%" cellspacing="0" cellpadding="0"><tr><td width="49%" height="20" bgcolor="#e1e1e1" style="padding-left:15px; border-bottom:1px solid #f3f3f3;"><b>Item Name</b></td><td width="18%" bgcolor="#e1e1e1" style="border-left:1px solid #f3f3f3;border-bottom:1px solid #f3f3f3; padding-left:10px;"><b>Unit</b></td><td width="14%" bgcolor="#e1e1e1" style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;"><b>Qty.</b></td><td width="19%" bgcolor="#e1e1e1" style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;"><b>Price</b></td></tr>';
        // pr($order_items);die;
        foreach ($order_items as $item) {
            if ($item['item_type'] == 'item' || $item['item_type'] == 'online_item') {
                $items.= '<tr><td height="20" style="padding-left:15px;border-bottom:1px solid #f3f3f3;">' . $item['item_name'] . '</td><td style="border-left:1px solid #f3f3f3;border-bottom:1px solid #f3f3f3; padding-left:10px;">' . $item['unit_name'] . '</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;">' . $item['item_quantity'] . '</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;">$' . number_format($item['unit_price'], '2', '.', '') . '</td></tr>';
            } else if ($item['item_type'] == 'package') {
                $order_package_items = $this->order->getOrderPackageItems($item['order_item_id']);
                $items.= '<tr><td height="20" colspan="3" style="padding-left:15px;border-bottom:1px solid #f3f3f3;"><h3>' . $item['item_name'] . '</h3></td><td height="20"  style="padding-left:15px;border-bottom:1px solid #f3f3f3;font-weight:bold;">$' . $item['total_item_price'] . '</td></tr>';
                foreach ($order_package_items as $order_package_item) {
                    $items.= '<tr><td height="20" style="padding-left:15px;border-bottom:1px solid #f3f3f3;">' . $order_package_item['item_name'] . '</td><td style="border-left:1px solid #f3f3f3;border-bottom:1px solid #f3f3f3; padding-left:10px;">' . $order_package_item['item_type'] . '</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;">' . $order_package_item['item_quantity'] . '</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;">$' . number_format($order_package_item['total_item_price'], '2', '.', '') . '</td></tr>';
                }
            }
        }
        $items.=' <tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">Sub Total</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->sub_total, 2, '.', '') . '</td></tr>';
        if ($order_detail->discount != '0' || $order_detail->discount != '0.00')
            $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">Discount</td></td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->discount, 2, '.', '') . '</td></tr>';
        if ($order_detail->gst_per != '0' || $order_detail->gst_per != '0.00') {
            $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">GST (' . $order_detail->gst_per . ' %)</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->gst, 2, '.', '') . '</td></tr>';
        }
        if ($order_detail->pst_per != '0' || $order_detail->pst_per != '0.00') {
            $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">PST (' . $order_detail->pst_per . ' %)</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->pst, 2, '.', '') . '</td></tr>';
        }
        if ($order_detail->hst_per != '0' || $order_detail->hst_per != '0.00') {
            $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">HST (' . $order_detail->hst_per . ' %)</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->hst, 2, '.', '') . '</td></tr>';
        }
         if ($order_detail->delivery_charges != '0' || $order_detail->delivery_charges != '0.00') {
               $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;">Delivery Charges ('.$order_detail->area_name.')</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">$ ' . number_format($order_detail->delivery_charges, 2, '.', '') . '</td></tr>';
        }
        $items.= '<tr><td height="20" style="border-bottom:1px solid #f3f3f3;padding-left:15px; color:#ed1b24; background-color:#f7dfe1;"><b>GRAND TOTAL</b></td><td style="border-bottom:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;padding-left:10px;color:#ed1b24; background-color:#f7dfe1;">&nbsp;</td><td style="border-bottom:1px solid #f3f3f3;border-left:1px solid #f3f3f3; padding-left:10px;color:#ed1b24; background-color:#f7dfe1;"><b>$' . number_format($order_detail->total_amount, 2, '.', '') . '</b></td></tr>';
        $items.='</table>';
        $sub_total = $order_detail->sub_total;
        $gst = $order_detail->gst;
        $pst = $order_detail->pst;
        $hst = $order_detail->hst;
        $total = $order_detail->total_amount;
        $template = $this->templatechoose(1);
        $str = str_replace("{#sitelogo}", $this->sitelogo, $template->template_description);
        $str = str_replace("{#order_id}", 'A1-' . $order_id, $str);
        $str = str_replace("{#customer_name}", ucfirst($order_detail->name), $str);
        $str = str_replace("{#customer_address}", $order_detail->address, $str);
        $str = str_replace("{#customer_location}", $order_detail->location_name, $str);
        $str = str_replace("{#delivery_location}", $order_detail->delivery_location_name, $str);
        $str = str_replace("{#delivery_location_phone}", $delivery_location_detail->telephone, $str);
        $str = str_replace("{#delivery_location_email}", $delivery_location_detail->province_email_id, $str);
        $str = str_replace("{#customer_phone}", $order_detail->phone, $str);
        $str = str_replace("{#customer_email}", $order_detail->email, $str);
        $str = str_replace("{#payment_type}", ucfirst(str_replace('_', ' ', $order_detail->payment_type)), $str);
        $str = str_replace("{#comments}", $order_detail->comments, $str);
        $str = str_replace("{#delivery_date}", date('d-m-Y', $order_detail->delivery_date), $str);
        $str = str_replace("{#delivery_time}", date('h:i A', $order_detail->delivery_time), $str);
        $str = str_replace("{#delivery_type}", $order_detail->delivery_type, $str);
        $str = str_replace("{#payment_status}", $order_detail->payment_status, $str);
        $str = str_replace("{#created_time}", date('d-m-Y h:i A', $order_detail->add_time), $str);
        $str = str_replace("{#items}", $items, $str);
        $str = str_replace("{#sub_total}", $sub_total, $str);
        $str = str_replace("{#gst}", $gst, $str);
        $str = str_replace("{#pst}", $pst, $str);
        $str = str_replace("{#hst}", $hst, $str);
        $str = str_replace("{#total}", $total, $str);
         if ($order_detail->payment_type == 'cash_on_delivery')
            $str = str_replace("{#cash_on_delivery_note}", '(Order is not confirmed without deposit)', $str);
        else
            $str = str_replace("{#cash_on_delivery_note}", '', $str);
        $this->email->from($template->sender_from_email, $template->email_from_name);
        //$this->email->to($delivery_location_detail->province_email_id);
        $this->email->to($template->sender_to_email);
        $this->email->bcc($template->sender_to_email . ',' . $order_detail->email);
        $this->email->mailtype = $this->mailtype;
        $this->email->subject($template->email_subject);
        $this->email->message($str);
   //     echo $str;
        $this->email->send();
       
    }

    function getAdminDataById($adminId) {
        $this->db->where('id', $adminId);
        $query = $this->db->get('tbl_admin');
        $row = $query->row();
        return $row;
    }

    function forgotPasswordEmail($memberRec, $adminId) {
        $admin_data = $this->getAdminDataById($adminId);
        $verificationCode = $admin_data->verification_code;
        $template = $this->templatechoose(2);
        $str = str_replace("{#background}", $this->background, $template->template_description);
        $verificatin_link = site_url('forgotPassword/validate/' . $verificationCode);
        $str = str_replace("{#logopath}", $this->sitelogo, $str);
        $str = str_replace("{#contact_email}", $this->contact_email, $str);
        $str = str_replace("{#username}", $memberRec->username, $str);
        $str = str_replace("{#email}", $memberRec->email, $str);
        $str = str_replace("{#site_url}", base_url(), $str);
        $str = str_replace("{#vlink}", $verificatin_link, $str);
        $str = str_replace("{#year}", date('Y'), $str);
        $this->email->from($template->sender_from_email, $template->email_from_name);
        $this->email->to($memberRec->email);
        $this->email->cc($template->sender_to_email);
        $this->email->mailtype = $this->mailtype;
        $this->email->subject($template->email_subject);
        $this->email->message($str);
        return $this->email->send();
    }

    function contactusmail() {
        $template = $this->templatechoose(6);
        $str = str_replace("{#background}", $this->background, $template->template_description);
        $str = str_replace("{#logopath}", $this->sitelogo, $str);
        $str = str_replace("{#full_name}", ucfirst($this->input->post('full_name')), $str);
        $str = str_replace("{#email_id}", $this->input->post('email_id'), $str);
        $str = str_replace("{#phone_no}", $this->input->post('phone_no'), $str);
        $str = str_replace("{#message}", $this->input->post('message'), $str);
        $this->email->from($template->sender_from_email, $template->email_from_name);
        $this->email->to($template->sender_to_email);
        $this->email->mailtype = $this->mailtype;
        $this->email->subject($template->email_subject);
        $this->email->message($str);
        return $this->email->send();
    }

}