<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class blog_model extends CI_Model {

    var $tableName = 'tbl_blog';
    var $tableCategoryName = 'tbl_blog_category';
    var $tableCommentName = 'tbl_blog_comment';

    function getBlogRecords() {       
        $this->db->where($this->tableName . '.status', 'active');         
        $query = $this->db->get($this->tableName);        
        $result = $query->result_array();
        return $result;
    }
    
    function getBlogCategoryRecords() {       
        $this->db->where($this->tableCategoryName . '.status', 'active');         
        $query = $this->db->get($this->tableCategoryName);        
        $result = $query->result_array();
        return $result;
    }
    
    function getBlogRecordsByName($added_by) { 
        $this->db->where($this->tableName . '.added_by', $added_by);
        $this->db->where($this->tableName . '.status', 'active');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }   

    public function getBlogRecordBySlug($slug) {
        $this->db->where($this->tableName . '.slug', $slug);
        $this->db->where($this->tableName . '.status', 'active');     
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    public function getBlogCommentList($blog_id) {
        $this->db->where('blog_id', $blog_id);
        $this->db->where($this->tableCommentName . '.status', 'active');
        $this->db->order_by($this->tableCommentName . '.add_time', 'desc');
        $query = $this->db->get($this->tableCommentName);
        $result = $query->result_array();
        return $result;
    }

    public function getBlogByCategoryId($category_id) {
        $this->db->where($this->tableName . '.category_id', $category_id); 
        $this->db->where($this->tableName . '.status', 'active');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    public function getBlogCategoryDetailById($category_id) {
        $this->db->where($this->tableCategoryName . '.blog_category_id', $category_id); 
        $this->db->where($this->tableCategoryName . '.status', 'active'); 
        $query = $this->db->get($this->tableCategoryName);
        $result = $query->row_array();
        return $result;
    }

    public function getBlogs($add_time) {

        $this->db->select('*,' . $this->tableName . '.add_time, YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))', $add_time);    
        $this->db->where($this->tableName . '.status', 'active');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }
    
    public function getBlogArchives($add_time) {
        $this->db->select('*,' . $this->tableName . '.add_time, YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))', $add_time);    
        $this->db->where($this->tableName . '.status', 'active');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }
    
    public function getBlogArchive() {
        $this->db->select('*,tbl_blog.add_time,MONTH(FROM_UNIXTIME(tbl_blog.add_time)), YEAR(FROM_UNIXTIME(tbl_blog.add_time))');
        $this->db->from('tbl_blog');  
        $this->db->where('tbl_blog.status', 'active'); 
        $this->db->group_by('YEAR(FROM_UNIXTIME(tbl_blog.add_time))');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }



    public function countBlogByCategoryId($category_id) {
        $this->db->where($this->tableName . '.category_id', $category_id);        
        $this->db->where($this->tableName . '.status', 'active');
            $query = $this->db->get($this->tableName);
        $result = $query->num_rows();
        return $result;
    }

    public function countArchiveByTime($add_time) {
        $this->db->select('*,' . $this->tableName . '.add_time, YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))');
        $this->db->where('YEAR(FROM_UNIXTIME(' . $this->tableName . '.add_time))', $add_time);  
        $this->db->where($this->tableName . '.status', 'active');    
        $query = $this->db->get($this->tableName);
        $result = $query->num_rows();
        return $result;
    }

    public function addBlogComment($blog_id) {
        if ($blog_id)
            $this->db->set('blog_id', $blog_id);
        if ($this->input->post('comment_by'))
            $this->db->set('comment_by', $this->input->post('comment_by'));
        if ($this->input->post('email'))
            $this->db->set('email', $this->input->post('email'));
        if ($this->input->post('phone'))
            $this->db->set('phone', $this->input->post('phone'));
        if ($this->input->post('subject'))
            $this->db->set('subject', $this->input->post('subject'));
        if ($this->input->post('comment'))
            $this->db->set('comment', $this->input->post('comment'));
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());
        $query = $this->db->insert($this->tableCommentName);
        $response = $this->db->insert_id();
        return $this->db->insert_id();
    }

    public function getRecentBlogs() {
        $this->db->from($this->tableName);  
        $this->db->where($this->tableName . '.status', 'active');
        $this->db->order_by($this->tableName . '.add_time', 'desc');
        $this->db->limit(4);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

}