<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Province_Model extends CI_Model {

    var $tableName = 'tbl_province';
    var $tableCountry = 'tbl_country';
    var $tableImages = 'tbl_province_images';

    function getProvinceList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name');
        $this->db->from($this->tableName);
        $this->db->join($this->tableCountry, $this->tableCountry . '.ct_id=tbl_province.country_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getProvinceListByCountry($country_id) {
        $this->db->where('country_id', $country_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getProvinceListById($provinceId) {
        $this->db->where('province_id', $provinceId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getCountryList() {
        $query = $this->db->get($this->tableCountry);
        $result = $query->result_array();
        return $result;
    }

    function getProvinceImagesById($provinceId) {
        if ($provinceId != '')
            $this->db->where($this->tableImages . '.province_id', $provinceId);
        $this->db->order_by('display_order', 'asc');

        $query = $this->db->get($this->tableImages);
        $result = $query->result_array();
        return $result;
    }

    function add($province_image) {
        if ($province_image)
            $this->db->set('province_image', $province_image);

        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('province_name'), 'tbl_province');
        $this->db->set('slug', $slug);

        if ($this->input->post('province_name'))
            $this->db->set('province_name', $this->input->post('province_name'));
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_description'))
            $this->db->set('province_description', $this->input->post('province_description'));
        if ($this->input->post('hours'))
            $this->db->set('hours', $this->input->post('hours'));
        if ($this->input->post('iframe_code'))
            $this->db->set('iframe_code', $this->input->post('iframe_code'));
        if ($this->input->post('province_email_id'))
            $this->db->set('province_email_id', $this->input->post('province_email_id'));
        if ($this->input->post('telephone'))
            $this->db->set('telephone', $this->input->post('telephone'));
        if ($this->input->post('address'))
            $this->db->set('address', $this->input->post('address'));
        if ($this->input->post('copyright_text'))
            $this->db->set('copyright_text', $this->input->post('copyright_text'));
        if ($this->input->post('gst') != '') {
            $this->db->set('gst', $this->input->post('gst'));
        } else {
            $this->db->set('pst', '0');
        }
        if ($this->input->post('gst') != '') {
            $this->db->set('pst', $this->input->post('pst'));
        } else {
            $this->db->set('pst', '0');
        }
        if ($this->input->post('gst') != '') {
            $this->db->set('hst', $this->input->post('hst'));
        } else {
            $this->db->set('hst', '0');
        }

        $this->db->set('status', 'active');

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($provinceId, $province_image) {
        if ($province_image)
            $this->db->set('province_image', $province_image);

        if ($this->input->post('province_name'))
            $this->db->set('province_name', $this->input->post('province_name'));
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_description'))
            $this->db->set('province_description', $this->input->post('province_description'));
        if ($this->input->post('hours'))
            $this->db->set('hours', $this->input->post('hours'));
        if ($this->input->post('iframe_code'))
            $this->db->set('iframe_code', $this->input->post('iframe_code'));
        if ($this->input->post('province_email_id'))
            $this->db->set('province_email_id', $this->input->post('province_email_id'));
        if ($this->input->post('telephone'))
            $this->db->set('telephone', $this->input->post('telephone'));
        if ($this->input->post('address'))
            $this->db->set('address', $this->input->post('address'));
        if ($this->input->post('copyright_text'))
            $this->db->set('copyright_text', $this->input->post('copyright_text'));
        if ($this->input->post('gst') != '') {
            $this->db->set('gst', $this->input->post('gst'));
        } else {
            $this->db->set('pst', '0');
        }
        if ($this->input->post('gst') != '') {
            $this->db->set('pst', $this->input->post('pst'));
        } else {
            $this->db->set('pst', '0');
        }
        if ($this->input->post('gst') != '') {
            $this->db->set('hst', $this->input->post('hst'));
        } else {
            $this->db->set('hst', '0');
        }
        $this->db->where('province_id', $provinceId);

        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateDefaultLanguage($provinceId, $action) {
        $this->db->set('default_location', $action);
        $this->db->where('province_id', $provinceId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    function updateDefault($provinceId, $action) {
        $this->db->set('default_location', $action);
        $this->db->where('province_id !=', $provinceId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($provinceId, $action) {
        $this->db->set('status', $action);
        $this->db->where('province_id', $provinceId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($provinceId) {
        $this->db->where('province_id', $provinceId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

    public function deleteProvinceImagesById($imageId) {
        $this->db->where('p_img_id', $imageId);
        $response = $this->db->delete($this->tableImages);
        return $response;
    }

    function addProvinceImage($provinceId, $image_name) {
        $this->db->set('province_id', $provinceId);
        $this->db->set('image_name', $image_name);
        $this->db->set('add_time', time());
        $query = $this->db->insert($this->tableImages);
        $response = $this->db->insert_id();
        return $response;
    }

    function updateProductImage($provinceId, $detail) {
        $this->addProductImage($provinceId, $detail);
    }

}
