<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Newsletter_Model extends CI_Model {

        var $tableName='tbl_newsletter';       
        var $tableNewsSubscribe='tbl_newsletter_subscription';       
   
    function getNewsletterList() {
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }    
    
    function getNewsletterById($newsId) {   
        $this->db->where($this->tableName.'.newsletter_id', $newsId);           
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }  
    
    function viewNewsById($newsId) { 
        $this->db->where('newsletter_id', $newsId);         
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }
    
     function subscriber_list() {  
        $query = $this->db->get($this->tableNewsSubscribe);
        $result = $query->result_array();
        return $result;
    } 
    
    function sendNewsletterRecordById($newsId) {
        $this->db->where($this->tableName.'.newsletter_id', $newsId); 
        $query = $this->db->get($this->tableName);
        $result = $query->row();
        return $result;
    } 
   
    function add($newsletter_title) {        
                 
            $slug = $this->common_model->create_unique_slug_for_common($newsletter_title,'tbl_newsletter');
            $this->db->set('slug',$slug); 
            if($this->input->post('newsletter_title'))
            $this->db->set('newsletter_title', $this->input->post('newsletter_title'));               
            if($this->input->post('newsletter_text'))
            $this->db->set('newsletter_text', $this->input->post('newsletter_text')); 
            $this->db->set('status','active');  
            $this->db->set('add_time', time());            

            $query = $this->db->insert($this->tableName);
            $response=$this->db->insert_id();
        return $response;
    }
    
     function update($newsId){
                if($this->input->post('newsletter_title'))
            $this->db->set('newsletter_title', $this->input->post('newsletter_title'));               
            if($this->input->post('newsletter_text'))
            $this->db->set('newsletter_text', $this->input->post('newsletter_text'));     
           $this->db->set('status','active');             
      
            $this->db->where('newsletter_id',$newsId);
            $query = $this->db->update($this->tableName);
            return $response;       
    }    
    
    public function updateStatus($newsId,$status) {
        $this->db->set('status',$status);
        $this->db->where('newsletter_id',$newsId);
        $response = $this->db->update($this->tableName);
        return $response; 
    }
    
    public function delete($newsId){        
        $this->db->where('newsletter_id',$newsId);
        $response = $this->db->delete($this->tableName);
        return $response; 
    }     
   
}
