<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class meta_tag_model extends CI_Model {

    var $tableName = 'tbl_metatag';

    function getMetatagList() {
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getMetatagListById($metatagId) {
        $this->db->where($this->tableName . '.meta_id', $metatagId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add($header_image, $background_image) {
        $this->db->set('metatag_title', $this->input->post('metatag_title'));
        $this->db->set('metatag_keyword', $this->input->post('metatag_keyword'));
        $this->db->set('metatag_description', $this->input->post('metatag_description'));
        $this->db->set('metatag_url', $this->input->post('metatag_url'));

        if ($header_image)
            $this->db->set('header_image', $header_image);
        if ($background_image)
            $this->db->set('background_image', $background_image);

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($metatagId, $header_image, $background_image) {
        $this->db->set('metatag_title', $this->input->post('metatag_title'));
        $this->db->set('metatag_keyword', $this->input->post('metatag_keyword'));
        $this->db->set('metatag_description', $this->input->post('metatag_description'));
        $this->db->set('metatag_url', $this->input->post('metatag_url'));
        if ($header_image)
            $this->db->set('header_image', $header_image);
        if ($background_image)
            $this->db->set('background_image', $background_image);
        $this->db->where('meta_id', $metatagId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($metatagId, $status) {
        $this->db->set('status', $status);
        $this->db->where('meta_id', $metatagId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($metatagId) {
        $this->db->where('meta_id', $metatagId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}
