<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Icon_Model extends CI_Model {

    var $tableName = 'tbl_top_icons';

    function getIconList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_region.region_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName .'.region_id',$location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_top_icons.country_id');
        $this->db->join('tbl_region', 'tbl_region.region_id=tbl_top_icons.region_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    

    function getIconListById($iconId) {     
            $this->db->where($this->tableName . '.icon_id', $iconId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add($icon_image) {
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('region_id'))
            $this->db->set('region_id', $this->input->post('region_id'));

        if ($this->input->post('icon_title'))
            $this->db->set('icon_title', $this->input->post('icon_title'));
        if ($icon_image)
            $this->db->set('icon_image', $icon_image);

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($iconId, $icon_image) {
        if ($icon_image)
            $this->db->set('icon_image', $icon_image);
        if ($this->input->post('icon_title'))
            $this->db->set('icon_title', $this->input->post('icon_title')); 
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('region_id'))
            $this->db->set('region_id', $this->input->post('region_id')); 

        $this->db->where('icon_id', $iconId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function updateStatus($iconId, $status) {
        $this->db->set('status', $status);
        $this->db->where('icon_id', $iconId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($iconId) {
        $this->db->where('icon_id', $iconId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }


}