<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Country_Model extends CI_Model {

    var $tableName = 'tbl_country';

    function getCountryList() {      
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }
    
    function getCountryListById($countryId) {        
        $this->db->where($this->tableName.'.ct_id', $countryId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add($country_name, $country_image) {
        if ($country_image)
            $this->db->set('image', $country_image);
        $slug = $this->common_model->create_unique_slug_for_common($country_name, 'tbl_country');
        $this->db->set('slug', $slug);
        if ($this->input->post('country_name'))
            $this->db->set('country_name', $this->input->post('country_name'));
        if ($this->input->post('currency_name'))
            $this->db->set('currency_name', $this->input->post('currency_name'));
        if ($this->input->post('code'))
            $this->db->set('code', $this->input->post('code'));
        $this->db->set('status', 'active');

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($countryId, $country_image) {
        if ($country_image)
            $this->db->set('image', $country_image);     
        if ($this->input->post('country_name'))
            $this->db->set('country_name', $this->input->post('country_name'));
        if ($this->input->post('currency_name'))
            $this->db->set('currency_name', $this->input->post('currency_name'));
        if ($this->input->post('code'))
            $this->db->set('code', $this->input->post('code'));
        $this->db->set('status', 'active');
        $this->db->where('ct_id', $countryId);

        $query = $this->db->update($this->tableName);
        return $response;
    }  
    
    public function getFileName($countryId){ 
        $this->db->where('ct_id',$countryId); 
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    public function updateStatus($countryId, $status) {
        $this->db->set('status', $status);
        $this->db->where('ct_id', $countryId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($countryId) {
        $this->db->where('ct_id', $countryId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}