<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Locations extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('cart_model', 'cart');
        $this->load->model('province_model', 'province');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('content_model', 'content');
    }

    public function index() {
        $data['province_list'] = $this->province->getAllProvince();
        $data['current_slug'] = $current_slug = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
        $content_detail = $this->content->getContentRecordBySlug($current_slug);
        $data['METATITLE'] = $content_detail->meta_title . ' | ' . $this->config->item('site_title');
        $data['METAKEYWORDS'] = $content_detail->meta_keywords;
        $data['METADESCRIPTION'] = $content_detail->meta_description;
        $data['METADESCRIPTION'] = $content_detail->meta_description;
        $data['page_heading'] = $content_detail->page_heading;
        $data['page_name'] = 'location';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/location');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function locationDetail($slug) {
        $data['province_detail'] = $province_detail = $this->province->getProvinceBySlug($slug);
        if (empty($province_detail)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        $data['gallery_data'] = $this->province->get_gallery_by_province($province_detail->province_id, '4');
        $data['METATITLE'] = $province_detail->province_name . ' | ' . $this->config->item('site_title');
        $data['METAKEYWORDS'] = $province_detail->province_name;
        $data['METADESCRIPTION'] = $province_detail->province_name;
        $data['page_heading'] = $province_detail->province_name;
        $data['page_name'] = 'location';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/location_detail');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function locationCopyright($slug) {
        $data['province_detail'] = $province_detail = $this->province->getProvinceBySlug($slug);
        if (empty($province_detail)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        $data['METATITLE'] = $province_detail->province_name . ' | ' . $this->config->item('site_title');
        $data['METAKEYWORDS'] = $province_detail->province_name;
        $data['METADESCRIPTION'] = $province_detail->province_name;
        $data['page_name'] = 'location';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/location_copyright');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function set_user_location() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('location_id', 'Location', 'trim|required');
            if ($this->form_validation->run()) {
                $this->session->set_userdata('location_id', $this->input->post('location_id'));
                $msg = 'true';
            } else {
                $msg = strip_tags(form_error('location_id'));
            }
            echo json_encode($msg);
        }
    }

    public function province_gallery($slug) {
        $province_detail = $this->common_model->getSingleRowFromAnyTable('slug', $slug, $this->province->tableName);
        if (empty($province_detail)) {
            redirect($_SERVER['HTTP_REFERER']);
            exit;
        }
        $data['gallery_data'] = $this->province->get_gallery_by_province($province_detail->province_id);
        $data['page_heading'] = $province_detail->province_name;
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/location_gallery');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function changeLocation($location_id) {
        $this->session->set_userdata('location_id', $location_id);
        $this->updateCartByLocation($location_id);
        redirect($_GET['redirect']);
    }

    public function updateCartByLocation($location_id = '') {
        $province_data = $this->province->getProvinceById($location_id);
        $sub_total = $this->cart_items->getCartItemsTotal();
        $sub_total = $sub_total['total_item_price'];
        $cart_data = $this->cart->getCartDetail();
        if ($cart_data) {
            $discount = $cart_data['discount'];
            $coupon_id = $cart_data['coupon_id'];
            $coupon_code = $cart_data['coupon_code'];
            $coupon_percentage = $cart_data['coupon_percentage'];
            $discounted_total = $sub_total - $discount;
            $gst = number_format((($discounted_total * $province_data->gst) / 100), 2, '.', '');
            $pst = number_format((($discounted_total * $province_data->pst) / 100), 2, '.', '');
            $hst = number_format((($discounted_total * $province_data->hst) / 100), 2, '.', '');
            $total_cart_price = number_format(($discounted_total + $gst + $pst + $hst), 2, '.', '');
            $data = array(
                'cart_id' => $cart_data['cart_id'],
                'sub_total' => $sub_total,
                'location_id' => $province_data->location_id,
                'location_name' => $province_data->location_name,
                'gst_per' => $province_data->gst,
                'pst_per' => $province_data->pst,
                'hst_per' => $province_data->hst,
                'discount' => $discount,
                'coupon_id' => $coupon_id,
                'coupon_code' => $coupon_code,
                'coupon_percentage' => $coupon_percentage,
                'gst' => $gst,
                'pst' => $pst,
                'hst' => $hst,
                'total_cart_price' => $total_cart_price,
            );
            $this->cart->updateCart($data);
        }
    }

}