<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gallery extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('gallery_model', 'gallery');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('content_model', 'content');
        $this->load->library('form_validation');
    }

    public function index($slug) {
        $province_data = $this->common_model->getSingleRowFromAnyTable('slug', $slug, 'tbl_province');
        $data['gallery_data'] = $this->gallery->getAllGalleryRecords($province_data->province_id);
        $data['page_heading'] = $province_data->province_name;
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/gallery');
        $this->load->view($this->config->item('template') . '/footer');
    }

}