<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Content extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('content_model', 'content');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->library('form_validation');
    }

    public function index($page_id) {
        #============Static Page Content According to Language=========================================#
        if (is_numeric($page_id)) {
            $output['content_detail'] = $content_detail = $this->content->getContentRecordByContentId($page_id);
            if ($content_detail->page_id == '') {
                $this->session->set_userdata('ERROR_MESSAGE', 'Sorry! The page you are requested is Not Found');
                redirect(site_url());
                exit;
            }
        } else {
            $output['content_detail'] = $content_detail = $this->content->getContentRecordBySlug($page_id);
            if ($content_detail->slug == '') {
                $this->session->set_userdata('ERROR_MESSAGE', 'Sorry! The page you are requested is Not Found');
                redirect(site_url());
                exit;
            }
        }
        $output['page_name'] = $content_detail->slug;
        $output['page_heading'] = $content_detail->page_heading;
        $output['page_content'] = $content_detail->page_content;
        #============Static Page Views=================================================================#
        $this->load->view($this->config->item('template') . '/header', $output);
        $this->load->view($this->config->item('template') . '/static_pages');
        $this->load->view($this->config->item('template') . '/footer');
    }

}
