<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Tray_Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/tray_category_model', 'trayCat');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
      
        $this->load->library('form_validation');
        $this->location_id = $this->session->userdata('location_id');
    }

    public function index() {     
        $data['category_data'] = $this->trayCat->getCategoryList();     
        $data['breadcum'] = 'Manage Category'; 
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/tray_category/tray_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }    

    public function add() {  
        
        if (!empty($_POST)) {             
           $tray_cat_name = $this->input->post('tray_cat_name');
            if ($_FILES['tray_cat_image']['name'] == '')
                $this->form_validation->set_rules('tray_cat_image', 'Tray category Image', 'trim|required');
            $this->form_validation->set_rules('tray_cat_name', 'Tray Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) { 
                  if ($_FILES["tray_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/tray_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('tray_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->trayCat->add($tray_cat_name,$detail['upload_data']['file_name']);
                $this->session->set_flashdata('TrayCategorySuccess', 'Tray Category Has Been Added Successfully');
                redirect($this->config->item('adminFolder').'/tray-category-list');
                exit;
            }else{
                $data['tray_cat_name'] = $tray_cat_name = $this->input->post('tray_cat_name');
                $data['tray_cat_description'] = $this->input->post('tray_cat_description');
                $data['tray_cat_image'] = $this->input->post('tray_cat_image');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');               
            }
        }
             
                $data['breadcum'] = 'Add Category';            
                $data['country_list'] = $this->country->getCountryList();               
     
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/tray_category/tray_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }  
 

    public function edit($trayCatId) { 
        if (!empty($_POST)) {
       
            $this->form_validation->set_rules('tray_cat_name', 'Tray Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                 if ($_FILES["tray_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/tray_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('tray_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->trayCat->update($trayCatId, $detail['upload_data']['file_name']);       
                $this->session->set_flashdata('TrayCategorySuccess', 'Tray Category Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/tray-category-list');               
                exit;
            }else{
                $data['tray_cat_name'] =  $this->input->post('tray_cat_name');
                $data['tray_cat_description'] = $this->input->post('tray_cat_description');
                $data['tray_cat_image'] = $this->input->post('tray_cat_image');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');                  
            }
        }
            $result = $this->trayCat->getCategoryById($trayCatId);              
            $data['traycat_id'] = $trayCatId;
            $data['tray_cat_name'] = $result['tray_cat_name'];
            $data['tray_cat_description'] = $result['tray_cat_description'];
            $data['tray_cat_image'] = $result['tray_cat_image'];
            $data['meta_title'] = $result['meta_title'];
            $data['meta_keywords'] = $result['meta_keywords'];
            $data['meta_description'] = $result['meta_description'];
            $data['country_id'] = $country_id = $result['country_id'];
            $data['province_id'] = $result['province_id'];
            $data['country_list'] = $this->country->getCountryList();         
            $data['province_list'] = $this->province->getProvinceListByCountry($country_id);  
            $data['breadcum_edit'] = 'Edit Category';           
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/tray_category/tray_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($trayCatId, $status) {
        if ($trayCatId != '') {
             $this->trayCat->updateStatus($trayCatId, $status);
            $this->session->set_flashdata('TrayCategorySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder').'/tray-category-list/');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/tray_category/tray_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($trayCatId) {    
        if (isset($trayCatId) && $trayCatId != '') { 
            $this->trayCat->delete($trayCatId);
            $this->session->set_flashdata('TrayCategorySuccess', 'Menu Category Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder').'/tray-category-list/');
            exit;
        }
    }

}
