<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Testimonial extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/testimonial_model', 'testimonial');       
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['testimonial_data'] = $this->testimonial->getTestimonialList();     
        $data['page_name'] = 'testimonial';
        $data['breadcum'] = 'Manage Testimonial';

        $this->load->view($this->config->item('adminFolder').'/header', $data);  
        $this->load->view($this->config->item('adminFolder').'/testimonial/testimonial_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function add() {  
         
        $data['page_name'] = 'testimonial';
        $data['breadcum'] = 'Add Testimonial';
        if (!empty($_POST)) {

            $data['name'] =  $this->input->post('name');
            $data['company'] = $this->input->post('company');
            $data['testimonial'] = $this->input->post('testimonial');     
            $data['testimonial_image'] = $this->input->post('testimonial_image');  
        
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('company', 'Company', 'trim|required');
            $this->form_validation->set_rules('testimonial', 'testimonial', 'trim|required');            
            if($_FILES["testimonial_image"]['name']=='')
            $this->form_validation->set_rules('testimonial_image', 'Testimonial Image', 'trim|required');
            
            if ($this->form_validation->run()) {

                if ($_FILES["testimonial_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/testimonial_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('testimonial_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->testimonial->add($detail['upload_data']['file_name']);
                
                 $this->session->set_flashdata('testimonialSuccess','Testimonial Has Been Added Successfully');  
                redirect($this->config->item('adminFolder').'/testimonial-list');
                exit;
            }
        }
        $this->load->view($this->config->item('adminFolder').'/header', $data);    
        $this->load->view($this->config->item('adminFolder').'/testimonial/testimonial_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function edit($testimonialId) {
       
        $result = $this->testimonial->getTestimonialById($testimonialId);            
              
        $data['testimonial_id'] = $testimonialId;
        $data['name'] = $result['name'];
        $data['company'] = $result['company'];
        $data['testimonial'] = $result['testimonial'];   
        $data['testimonial_image'] = $result['testimonial_image'];   
        $data['page_name'] = 'testimonial';
        $data['breadcum_edit'] = 'Edit Testimonial';

        if (!empty($_POST)) {
            
            $data['name'] = $testimonial_title = $this->input->post('name');
            $data['company'] = $this->input->post('company');
            $data['testimonial'] = $this->input->post('testimonial');     
            $data['testimonial_image'] = $this->input->post('testimonial_image');              
         
            $this->form_validation->set_rules('name', 'Name', 'trim|required');
            $this->form_validation->set_rules('company', 'Company', 'trim|required');
            $this->form_validation->set_rules('testimonial', 'testimonial', 'trim|required');            

            if ($this->form_validation->run()) {

               if ($_FILES["testimonial_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/testimonial_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('testimonial_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->testimonial->update($testimonialId,$detail['upload_data']['file_name']);             
                $this->session->set_flashdata('testimonialSuccess','Testimonial Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/testimonial-list');
                exit;
            }
        }    
        $this->load->view($this->config->item('adminFolder').'/header', $data);      
        $this->load->view($this->config->item('adminFolder').'/testimonial/testimonial_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function approve($testimonialId, $status) {
        if ($testimonialId != '') {
            $this->testimonial->updateStatus($testimonialId, $status);
            $this->session->set_flashdata('testimonialSuccess','Status Of This Record Has Been Updated Successfully');  
            redirect($this->config->item('adminFolder').'/testimonial-list');
            exit;
        }        
        $this->load->view($this->config->item('adminFolder').'/header', $data);      
        $this->load->view($this->config->item('adminFolder').'/testimonial/testimonial_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function delete($testimonialId) {
        if (isset($testimonialId) && $testimonialId != '') {
            $this->testimonial->delete($testimonialId);
            $this->session->set_flashdata('testimonialSuccess','Testimonial Has Been Deleted Successfully');     
            redirect($this->config->item('adminFolder').'/testimonial-list');
            exit;
        }
    }

}