<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sidebanner extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/sidebanner_model', 'sidebanner');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
        $this->load->library('form_validation');
        $this->location_id = $this->session->userdata('location_id');
    }

    public function index() {   
        $data['sidebanner_data'] = $this->sidebanner->getSidebannerList();  
        $data['breadcum'] = 'Manage Promotional Banner';
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/sidebanner/sidebar_banner_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {     

        if (!empty($_POST)) {
          
            if ($_FILES["sidebanner_image"]['name'] == '')
                $this->form_validation->set_rules('sidebanner_image', 'SideBar Banner Image', 'trim|required');
            $this->form_validation->set_rules('sidebanner_link', 'SideBar Banner Link', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["sidebanner_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/sidebar_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('sidebanner_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->sidebanner->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('promotionalBannerSuccess', 'Promotional Banner Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/promotional-banner-list');
                exit;
            }else{
                $data['sidebanner_link'] = $this->input->post('sidebanner_link');
                $data['sidebanner_image'] = $this->input->post('sidebanner_image');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');                
            }
        }             
                $data['breadcum'] = 'Add Promotional Banner';              
                $data['country_list'] = $this->country->getCountryList();            
      
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/sidebanner/sidebar_banner_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($sidebannerId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('sidebanner_link', 'Sidebar Banner Link', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');
            
            if ($this->form_validation->run()) {
                if ($_FILES["sidebanner_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/sidebar_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('sidebanner_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->sidebanner->updateSlug($sidebannerId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('promotionalBannerSuccess', 'Promotional Banner Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/promotional-banner-list');
                exit;
            }else{
                    $data['sidebanner_link'] = $this->input->post('sidebanner_link');
                    $data['sidebanner_image'] = $this->input->post('sidebanner_image');
                    $data['country_id'] = $this->input->post('country_id');
                    $data['province_id'] = $this->input->post('province_id');                
            }
        }
            $lists = $this->sidebanner->getSidebarBannerListById($sidebannerId);
            $data['country_id'] = $country_id = $lists['country_id'];
            $data['country_list'] = $this->country->getCountryList();         
            $data['province_list'] = $this->province->getProvinceListByCountry($country_id); 

            $data['sidebanner_id'] = $lists['sidebanner_id'];
            $data['sidebanner_link'] = $lists['sidebanner_link'];
            $data['sidebanner_image'] = $lists['sidebanner_image'];
            $data['country_id'] = $lists['country_id'];
            $data['province_id'] = $lists['province_id'];
            $data['page_name'] = 'promotionalBanner';    
            $data['breadcum_edit'] = 'Edit Promotional Banner';            
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);    
        $this->load->view($this->config->item('adminFolder') . '/sidebanner/sidebar_banner_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($sidebannerId, $status) {
        if ($sidebannerId != '') {
            $this->sidebanner->updateStatus($sidebannerId, $status);
            $this->session->set_flashdata('promotionalBannerSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/promotional-banner-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data); 
        $this->load->view($this->config->item('adminFolder') . '/sidebanner/sidebar_banner_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($sidebannerId) {
        $side_banner = $this->common_model->getSingleFieldFromAnytable('sidebanner_image','sidebanner_id',$sidebannerId,$this->sidebanner->tableName);       
        if (isset($sidebannerId) && $sidebannerId != '') {
            unlink('assets/uploads/sidebar_images/' . $side_banner);
            $this->sidebanner->delete($sidebannerId);
            $this->session->set_flashdata('promotionalBannerSuccess', 'Promotional Banner Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/promotional-banner-list');
            exit;
        }
    }

}