<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/package_model', 'package');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['package_data'] = $this->package->getPackageList();
        $data['breadcum'] = 'Manage Package';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package/package_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('name', 'Package Title', 'trim|required');
            $this->form_validation->set_rules('price', 'Price', 'trim|required');
            $this->form_validation->set_rules('min_order_amount', 'Minimum Order Amount', 'trim|required');
            //   $this->form_validation->set_rules('description', 'Package Description', 'trim|required');
            if ($this->form_validation->run()) {
                $this->package->addPackage();
                $this->session->set_flashdata('PackageSuccess', 'Package Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/package-list');
                exit;
            } else {
                $data['name'] = $this->input->post('name');
                $data['price'] = $this->input->post('price');
                $data['min_order_amount'] = $this->input->post('min_order_amount');
                $data['description'] = $this->input->post('description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        }
        $data['breadcum'] = 'Add Package';
        $data['country_list'] = $this->country->getCountryList(); 
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package/package_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($packageId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('name', 'Package Title', 'trim|required');
            $this->form_validation->set_rules('price', 'Price', 'trim|required');
            $this->form_validation->set_rules('min_order_amount', 'Minimum Order Amount', 'trim|required');
            // $this->form_validation->set_rules('description', 'Package Description', 'trim|required');
            if ($this->form_validation->run()) {
                $this->package->update($packageId);
                $this->session->set_flashdata('PackageSuccess', 'Package Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/package-list');
                exit;
            } else {
                $data['name'] = $this->input->post('name');
                $data['price'] = $this->input->post('price');
                $data['min_order_amount'] = $this->input->post('min_order_amount');
                $data['description'] = $this->input->post('description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        } else {
            $lists = $this->package->getPackageListById($packageId);
            $data['package_id'] = $packageId;
            $data['country_id'] = $country_id = $lists['country_id'];
            $data['province_id'] = $lists['province_id']; 
            $data['name'] = $lists['name'];
            $data['price'] = $lists['price'];
            $data['min_order_amount'] = $lists['min_order_amount'];
            $data['description'] = $lists['description'];
            $data['country_list'] = $this->country->getCountryList();         
            $data['province_list'] = $this->province->getProvinceListByCountry($country_id);
        }
        $data['breadcum_edit'] = 'Edit Package';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package/package_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function packageSpecifications($packageId) {
        if (!empty($_POST)) {
            $this->package->deleteSpecificationsByPackageId($packageId);
            $this->package->addPackageSpecifications($packageId);
            $this->session->set_userdata('pkg_success_msg', 'Package Specifications Has Been Updated Successfully');
            redirect('admin/package-specification/' . $packageId);
            exit;
        } else {
            $data['packageId'] = $packageId;
            $data['breadcum'] = 'Manage Package Specifications';
            $data['package_category'] = $this->package->getPackageCategoryList();
            $data['packg_item'] = $this->package->getPackageItemList();
            $data['specificationList'] = $this->package->getPackageSpecificationList($packageId);
            $this->load->view($this->config->item('adminFolder') . '/header', $data);
            $this->load->view($this->config->item('adminFolder') . '/package/package_specification');
            $this->load->view($this->config->item('adminFolder') . '/footer');
        }
    }

    public function approve($packageId, $status) {
        if ($packageId != '') {
            $this->package->updateStatus($packageId, $status);
            $this->session->set_flashdata('PackageSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/package-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package/package_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($packageId) {
        if (isset($packageId) && $packageId != '') {
            $this->package->delete($packageId);
            $this->session->set_flashdata('PackageSuccess', 'Package Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/package-list');
            exit;
        }
    }

    public function deleteSpecification($specificId, $package_id) {
        if (isset($specificId) && $specificId != '') {
            $this->package->deleteSpecifications($specificId);
            $this->session->set_flashdata('PackageSuccess', 'Package Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/package-specification/' . $package_id);
            exit;
        }
    }

    public function getPackageItemList() {
        $category_id = $this->input->post('category_id');
        $data['package_item'] = $package_item = $this->package->getItemsByPackageCat($category_id);

        $data['success'] = true;
        if (sizeof($package_item) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }

}
