<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Order extends CI_Controller {

    public function __construct() {
        parent::__construct();
         $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/order_model', 'order');
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['order_data'] = $this->order->getOrderList();
        $data['page_name'] = 'orderDetail';
        $data['breadcum'] = 'Manage Orders';

        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/order/order_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }
    
    public function view($orderId){ 
        $data['view_data'] = $this->order->getOrderListById($orderId);     
        $data['order_item'] = $this->order->getOrderItemListById($orderId);    
 
           
        $this->load->view($this->config->item('adminFolder').'/order/order_view',$data);     
    }
  

    public function approve($orderId, $status) {
        if ($orderId != '') {
            $this->order->updateStatus($orderId, $status);
            $this->session->set_flashdata('OrderSuccess','Status Of This Record Has Been Updated Successfully');     
            redirect('admin/order-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder').'/header', $data); 
        $this->load->view($this->config->item('adminFolder').'/order/order_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function delete($orderId) {
        if (isset($orderId) && $orderId != '') {
            $this->order->delete($orderId);
            $this->session->set_flashdata('OrderSuccess','Order Has Been Deleted Successfully');     
            redirect('admin/order-list');
            exit;
        }
    }

}