<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Online_Item extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/online_item_model', 'onlineItem');
        $this->load->model($this->config->item('adminFolder') . '/city_model', 'city');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['item_data'] = $this->onlineItem->getOnlineItemList();
        $data['breadcum'] = 'Manage Online Item';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_item/online_item_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $online_item_name = $this->input->post('item_name');

            $this->form_validation->set_rules('category_id', 'Category', 'trim|required');
            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');


            if ($this->form_validation->run()) {
                if ($_FILES["item_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/online_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $config['file_name'] = time();
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->onlineItem->add($online_item_name, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProductSuccess', 'Online Item Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/online-item-list');
                exit;
            } else {
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');
                $data['item_description'] = $this->input->post('item_description');
                $data['item_image'] = $this->input->post('item_image');
            }
        }
        $data['category_data'] = $this->onlineItem->getOnlineCategoryList();
        $data['breadcum'] = 'Add Online Item';


        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_item/online_item_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($onlineId) {
        if (!empty($_POST)) {

            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');


            if ($this->form_validation->run()) {
                if ($_FILES["item_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/online_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $config['file_name'] = time();
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->onlineItem->update($onlineId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProductSuccess', 'Online Item Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/online-item-list');
                exit;
            } else {
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $item_name = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');
                $data['item_description'] = $this->input->post('item_description');
                $data['item_image'] = $this->input->post('item_image');
            }
        } else {
            $result = $this->onlineItem->getOnlineItemListById($onlineId);

            $data['item_id'] = $onlineId;
            $data['category_id'] = $result['category_id'];
            $data['item_name'] = $result['item_name'];
            $data['item_code'] = $result['item_code'];
            $data['item_description'] = $result['item_description'];
            $data['item_image'] = $result['item_image'];
        }
        $data['category_data'] = $this->onlineItem->getOnlineCategoryList();
        $data['breadcum_edit'] = 'Edit Online Item';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_item/online_item_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($onlineId, $status) {
        if ($onlineId != '') {
            $this->onlineItem->updateStatus($onlineId, $status);
            $this->session->set_flashdata('ProductSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/online-item-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_item/online_item_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($onlineId) {
        if (isset($onlineId) && $onlineId != '') {
            //  unlink('assets/uploads/online_item_images/'.$product_name);
            $this->onlineItem->delete($onlineId);
            $this->session->set_flashdata('ProductSuccess', 'Online Item Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/online-item-list');
            exit;
        }
    }

    public function getCategoryList() {
        $category_id = $this->input->post('category_id');
        $data['category_list'] = $category_list = $this->onlineItem->getSubcategoryByCategory($category_id);

        $currentLevel = $this->common_model->getCategoryLevel($category_id);
        $data['catlevel'] = $catlevel = $currentLevel + 1;
        if ($category_list) {
            $response['html'] = $this->load->view($this->config->item('adminFolder') . '/online_category/category_div', $data, true);
        }

        $response['remove_div'] = $catlevel;
        $response['success'] = true;
        $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($response));
    }

    public function unitSpecifications($onlineItemId) {
        if (!empty($_POST)) {
            // pr($_POST);die;
            $this->onlineItem->deleteUnitSpecifications($onlineItemId);
            $this->onlineItem->addUnitSpecifications($onlineItemId);
            $this->session->set_userdata('unit_success_msg', 'Unit Specifications Has Been Updated Successfully');
            redirect('admin/online-unit-specification/' . $onlineItemId);
            exit;
        } else {
           
            $data['breadcum'] = 'Manage Unit Specifications';
            $data['specificationList'] = $this->onlineItem->getUnitSpecificationList($onlineItemId);
            $this->load->view($this->config->item('adminFolder') . '/header', $data);
            $this->load->view($this->config->item('adminFolder') . '/online_item/unit_specification');
            $this->load->view($this->config->item('adminFolder') . '/footer');
        }
    }

}