<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Online_Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/online_category_model', 'onlineCat');
        $this->load->model($this->config->item('adminFolder') . '/country_model', 'country');
        $this->load->model($this->config->item('adminFolder') . '/province_model', 'province');

        $this->load->library('form_validation');
        $this->location_id = $this->session->userdata('location_id');
    }

    public function index() {
        $data['category_data'] = $this->onlineCat->getCategoryList();
        $data['breadcum'] = 'Manage Category';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_category/online_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {

        if (!empty($_POST)) {
            $online_cat_name = $this->input->post('online_cat_name');
            if ($_FILES['online_cat_image']['name'] == '')
                $this->form_validation->set_rules('online_cat_image', 'Online category Image', 'trim|required');
            $this->form_validation->set_rules('online_cat_name', 'Online Category Name', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["online_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/online_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('online_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->onlineCat->add($online_cat_name, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('OnlineCategorySuccess', 'Online Category Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/online-category-list');
                exit;
            } else {
                $data['online_cat_name'] = $online_cat_name = $this->input->post('online_cat_name');
                $data['online_cat_description'] = $this->input->post('online_cat_description');
                $data['parent_category'] = $this->input->post('parent_category');
                $data['online_cat_image'] = $this->input->post('online_cat_image');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        }

        $data['breadcum'] = 'Add Category';
        $data['country_list'] = $this->country->getCountryList();
$data['category_data'] = $this->onlineCat->getCategoryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_category/online_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($onlineCatId) {
        if (!empty($_POST)) {

            $this->form_validation->set_rules('online_cat_name', 'Online Category Name', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["online_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/online_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('online_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->onlineCat->update($onlineCatId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('OnlineCategorySuccess', 'Online Category Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/online-category-list');
                exit;
            } else {
                $data['online_cat_name'] = $this->input->post('online_cat_name');
                $data['online_cat_description'] = $this->input->post('online_cat_description');
                $data['online_cat_image'] = $this->input->post('online_cat_image');
                 $data['parent_category'] = $this->input->post('parent_category');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        }
        $result = $this->onlineCat->getCategoryById($onlineCatId);
        $data['onlinecat_id'] = $onlineCatId;
        $data['online_cat_name'] = $result['online_cat_name'];
         $data['parent_category'] = $result['parent_category'];
        $data['online_cat_description'] = $result['online_cat_description'];
        $data['online_cat_image'] = $result['online_cat_image'];
        $data['meta_title'] = $result['meta_title'];
        $data['meta_keywords'] = $result['meta_keywords'];
        $data['meta_description'] = $result['meta_description'];
        $data['country_id'] = $country_id = $result['country_id'];
        $data['province_id'] = $result['province_id'];
        $data['country_list'] = $this->country->getCountryList();
        $data['province_list'] = $this->province->getProvinceListByCountry($country_id);
        $data['breadcum_edit'] = 'Edit Category';
$data['category_data'] = $this->onlineCat->getCategoryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_category/online_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($onlineCatId, $status) {
        if ($onlineCatId != '') {
            $this->onlineCat->updateStatus($onlineCatId, $status);
            $this->session->set_flashdata('OnlineCategorySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/online-category-list/');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/online_category/online_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($onlineCatId) {
        if (isset($onlineCatId) && $onlineCatId != '') {
            $this->onlineCat->delete($onlineCatId);
            $this->session->set_flashdata('OnlineCategorySuccess', 'Menu Category Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/online-category-list/');
            exit;
        }
    }

}
