<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Newsletter extends CI_Controller {

    public function __construct() {
        parent::__construct();    
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/newsletter_model', 'newsletter');     
        $this->load->model('mailsending_model');    
         
        $this->load->library('form_validation');        
    }  
    
    public function index() {    
        $data['news_data'] = $this->newsletter->getNewsletterList();      
        $data['breadcum'] = 'Manage Newsletter';
        $this->load->view($this->config->item('adminFolder').'/header',$data); 
        $this->load->view($this->config->item('adminFolder').'/newsletter/newsletter_list');          
        $this->load->view($this->config->item('adminFolder').'/footer');   
    }    
    
     public function view($newsId){  
        $data['view_data'] = $this->newsletter->viewNewsById($newsId);  
        $data['breadcum'] = 'NewsLetter Detail';  
        $this->load->view($this->config->item('adminFolder').'/newsletter/newsletter_view',$data);   
    }
    
    public function send_newsletter($newsId) {
        $subscriber_data = $this->newsletter->subscriber_list();
      
	$newsletter = $this->newsletter->sendNewsletterRecordById($newsId);
        foreach ($subscriber_data as $val)
	    {
		$this->mailsending_model->sendNewsletter($val['email_address'],$newsletter);
	    }
	    redirect($this->config->item('adminFolder').'/newsletter-list'); 
    }
    
    public function add(){       
        $data['breadcum'] = 'Add Newsletter';
      
                   if(!empty($_POST)){  
                                $data['newsletter_title'] = $newsletter_title = $this->input->post('newsletter_title');                              
                                $data['newsletter_text'] = $this->input->post('newsletter_text');  
                               
                                $this->form_validation->set_rules('newsletter_title','Newsletter Title','trim|required');  
                                $this->form_validation->set_rules('newsletter_text','Newsletter Text','trim|required');       
             
                                if($this->form_validation->run()){                                                                  
                                    $this->newsletter->add($newsletter_title);                                    
                                    $this->session->set_flashdata('NewsSuccess','Newsletter Has Been Added Successfully');       
                                    redirect($this->config->item('adminFolder').'/newsletter-list'); 
                                    exit;
            }
       }   
        $this->load->view($this->config->item('adminFolder').'/header',$data); 
        $this->load->view($this->config->item('adminFolder').'/newsletter/newsletter_form');          
        $this->load->view($this->config->item('adminFolder').'/footer');
   }
   
     public function edit($newsId){       
       
        $lists = $this->newsletter->getNewsletterById($newsId);
        $data['news_id'] = $lists['newsletter_id'];
        $data['newsletter_title'] = $lists['newsletter_title'];       
        $data['newsletter_text'] = $lists['newsletter_text'];   
        $data['breadcum_edit'] = 'Edit Newsletter';
       
                        if(!empty($_POST)){                            
                                $data['newsletter_title']  = $this->input->post('newsletter_title');                              
                                $data['newsletter_text'] = $this->input->post('newsletter_text');                   
                                 
                                    $this->form_validation->set_rules('newsletter_title','Newsletter Title','trim|required');  
                                    $this->form_validation->set_rules('newsletter_text','Newsletter Text','trim|required');  
           
                                    if($this->form_validation->run()){                                        
                                    $bannerData = $this->newsletter->update($newsId);
                                    $this->session->set_flashdata('NewsSuccess','Newsletter Has Been Updated Successfully');
                                    redirect($this->config->item('adminFolder').'/newsletter-list'); 
                                    exit;            
            }
        }
        
        $this->load->view($this->config->item('adminFolder').'/header',$data); 
        $this->load->view($this->config->item('adminFolder').'/newsletter/newsletter_form');          
        $this->load->view($this->config->item('adminFolder').'/footer');  
   }
   
    public function approve($newsId,$status){ 
                      if($newsId!=''){
                                $bannerData = $this->newsletter->updateStatus($newsId,$status);
                                $this->session->set_flashdata('NewsSuccess','Status Of This Record Has Been Updated Successfully');     
                                redirect($this->config->item('adminFolder').'/newsletter-list'); 
                                exit;        
        }      
        $this->load->view($this->config->item('adminFolder').'/header',$data); 
        $this->load->view($this->config->item('adminFolder').'/newsletter/newsletter_list');          
        $this->load->view($this->config->item('adminFolder').'/footer');     
   }
   
    public function delete($newsId){       
        if(isset($newsId) && $newsId != ''){           
            $this->newsletter->delete($newsId);    
               $this->session->set_flashdata('NewsSuccess','Newsletter Has Been Deleted Successfully');     
             redirect($this->config->item('adminFolder').'/newsletter-list'); 
            exit;        
        }        
    }
   
}