<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Meta_Tag extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/meta_tag_model', 'metatag');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['metatag_data'] = $this->metatag->getMetatagList();
        $data['breadcum'] = 'Manage Meta Tags';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meta_tag/meta_tag_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {

        if (!empty($_POST)) {
            $this->form_validation->set_rules('metatag_title', 'Meta Tag Title', 'trim|required');
            $this->form_validation->set_rules('metatag_keyword', 'Meta Tag Keyword', 'trim|required');
            $this->form_validation->set_rules('metatag_description', 'Meta Tag Description', 'trim|required');
            $this->form_validation->set_rules('metatag_url', 'Meta Tag URL', 'trim|required|valid_url');

            if ($this->form_validation->run()) {
                if ($_FILES["header_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/header_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('header_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }

                if ($_FILES["background_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/background_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('background_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail1 = array('upload_data' => $this->upload->data());
                    }
                }
                $this->metatag->add($detail['upload_data']['file_name'], $detail1['upload_data']['file_name']);
                $this->session->set_flashdata('MetatagSuccess', 'Meta Tags Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/meta-tag-list');
                exit;
            } else {
                $data['metatag_title'] = $this->input->post('metatag_title');
                $data['metatag_keyword'] = $this->input->post('metatag_keyword');
                $data['metatag_description'] = $this->input->post('metatag_description');
                $data['metatag_url'] = $this->input->post('metatag_url');
                $data['header_image'] = $this->input->post('header_image');
                $data['background_image'] = $this->input->post('background_image');
            }
        }
        $data['breadcum'] = 'Add Meta Tag';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meta_tag/meta_tag_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($metatagId) {

        if (!empty($_POST)) {
            $this->form_validation->set_rules('metatag_title', 'Meta Tag Title', 'trim|required');
            $this->form_validation->set_rules('metatag_keyword', 'Meta Tag keyword', 'trim|required');
            $this->form_validation->set_rules('metatag_description', 'Meta Tag Description', 'trim|required');
            $this->form_validation->set_rules('metatag_url', 'Meta Tag URL', 'trim|required|valid_url');

            if ($this->form_validation->run()) {
                if ($_FILES["header_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/header_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('header_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }

                if ($_FILES["background_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/background_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('background_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail1 = array('upload_data' => $this->upload->data());
                    }
                }

                $this->metatag->update($metatagId, $detail['upload_data']['file_name'], $detail1['upload_data']['file_name']);
                $this->session->set_flashdata('MetatagSuccess', 'Metatag Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/meta-tag-list');
                exit;
            } else {
                $data['metatag_title'] = $this->input->post('metatag_title');
                $data['metatag_keyword'] = $this->input->post('metatag_keyword');
                $data['metatag_description'] = $this->input->post('metatag_description');
                $data['metatag_url'] = $this->input->post('metatag_url');
                $data['header_image'] = $this->input->post('header_image');
                $data['background_image'] = $this->input->post('background_image');
            }
        } else {
            $lists = $this->metatag->getMetatagListById($metatagId);

            $data['meta_id'] = $lists['meta_id'];
            $data['metatag_title'] = $lists['metatag_title'];
            $data['metatag_keyword'] = $lists['metatag_keyword'];
            $data['metatag_description'] = $lists['metatag_description'];
            $data['metatag_url'] = $lists['metatag_url'];
            $data['header_image'] = $lists['header_image'];
            $data['background_image'] = $lists['background_image'];
        }
        $data['breadcum'] = 'Edit Meta Tag';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meta_tag/meta_tag_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($metatagId, $status) {
        if ($metatagId != '') {
            $this->metatag->updateStatus($metatagId, $status);
            $this->session->set_flashdata('MetatagSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/meta-tag-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meta_tag/meta_tag_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($metatagId) {
        if (isset($metatagId) && $metatagId != '') {
            $this->metatag->delete($metatagId);
            $this->session->set_flashdata('MetatagSuccess', 'Metatag Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/meta-tag-list');
            exit;
        }
    }

}
