<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menu_Item extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/menu_item_model', 'menuItem');       
        $this->load->model($this->config->item('adminFolder').'/tray_item_model', 'menuItem'); 
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['item_data'] = $this->menuItem->getMenuItemList();     
        $data['breadcumb'] = 'Manage Menu Item';
        
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/menu_item/menu_item_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function add() { 
        if (!empty($_POST)) {
            
            $menu_item_name = $this->input->post('item_name');                          
         
            $this->form_validation->set_rules('category_id', 'Item Category', 'trim|required');
            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required'); 
            $this->form_validation->set_rules('item_price', 'Item Price', 'trim|required');   
            
            if ($this->form_validation->run()) {
                 if ($_FILES["item_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/menu_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->menuItem->add($menu_item_name, $detail['upload_data']['file_name']);                
                $this->session->set_flashdata('MenuItemSuccess','Menu Item Has Been Added Successfully');  
                redirect($this->config->item('adminFolder').'/menu-item-list');
                exit;
            }else{
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');
                $data['item_price'] = $this->input->post('item_price');
                $data['item_description']  = $this->input->post('item_description');            
                $data['item_image'] = $this->input->post('item_image');     
              
            }            
        }
                $data['category_data'] = $this->menuItem->getMenuCategoryList();                              
                $data['breadcumb'] = 'Add Menu Item';           
       

        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/menu_item/menu_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function edit($menuId) { 
        if (!empty($_POST)) {     
                
            $this->form_validation->set_rules('category_id', 'Item Category', 'trim|required');
            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');  
            $this->form_validation->set_rules('item_price', 'Item Price', 'trim|required');   

            if ($this->form_validation->run()) {
                   if ($_FILES["item_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/menu_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->menuItem->update($menuId, $detail['upload_data']['file_name']);             
                $this->session->set_flashdata('MenuItemSuccess','Menu Item Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/menu-item-list');
                exit;
            }else{
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $item_name = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');       
                $data['item_description']  = $this->input->post('item_description');            
                $data['item_image'] = $this->input->post('item_image');
                $data['item_price'] = $this->input->post('item_price');
            }            
        }else{
            
            $result = $this->menuItem->getMenuItemListById($menuId);            
              
        $data['item_id'] = $menuId;
        $data['category_id'] = $result['category_id'];  
        $data['item_name'] = $result['item_name'];
        $data['item_code'] = $result['item_code']; 
        $data['item_price'] = $result['item_price']; 
        $data['item_description'] = $result['item_description'];
        $data['item_image'] = $result['item_image']; 
                     
        }    
        $data['category_data'] = $this->menuItem->getMenuCategoryList();  
        $data['breadcumb'] = 'Edit Menu Item'; 
     
		
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/menu_item/menu_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function approve($menuId, $status) {
        if ($menuId != '') {
            $this->menuItem->updateStatus($menuId, $status);
            $this->session->set_flashdata('MenuItemSuccess','Status Of This Record Has Been Updated Successfully');  
            redirect($this->config->item('adminFolder').'/menu-item-list');
            exit;
        }        
       $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/menu_item/menu_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function delete($menuId) {       
        if (isset($menuId) && $menuId != '') {
           //  unlink('assets/uploads/tray_item_images/'.$product_name);
            $this->menuItem->delete($menuId);
             $this->session->set_flashdata('MenuItemSuccess','Menu Item Has Been Deleted Successfully');     
            redirect($this->config->item('adminFolder').'/menu-item-list');
            exit;
        }
    }
    
    public function menuUnitSpecifications($menuItemId) {
        if (!empty($_POST)) {        
           // pr($_POST);die;
            $this->menuItem->deleteUnitSpecifications($menuItemId);
            $this->menuItem->addUnitSpecifications($menuItemId);
            $this->session->set_userdata('unit_success_msg', 'Unit Specifications Has Been Updated Successfully');
            redirect('admin/menu-unit-specification/' . $menuItemId);
            exit;
        } else {
            $result = mysql_query("SHOW TABLE STATUS LIKE 'tbl_menu_units'");
            $qdata = mysql_fetch_assoc($result); //pr($qdata);die;
            $data['next_increment'] = $qdata['Auto_increment'];         
            $data['breadcum'] = 'Manage Unit Specifications';                   
            $data['specificationList'] = $this->menuItem->getUnitSpecificationList($menuItemId);
            $this->load->view($this->config->item('adminFolder') . '/header', $data);
            $this->load->view($this->config->item('adminFolder') . '/tray_item/unit_specification');
            $this->load->view($this->config->item('adminFolder') . '/footer');
        }
    }
}