<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/login_model', 'login');
        $this->load->model('mailsending_model', 'mailsending');
        $this->load->model($this->config->item('adminFolder') . '/admin_log_model', 'adminlog');
    }

    function checkAdminLogin() {
        if ($this->session->userdata('admin_id') != '') {
            redirect($this->config->item('adminFolder') . '/dashboard');
            exit;
        }
    }

    public function index() {
        $this->load->library('user_agent');
        if (!empty($_POST)) {
            $this->form_validation->set_rules('username', 'username', 'trim|required');
            $this->form_validation->set_rules('password', 'password', 'trim|required');
            if ($this->form_validation->run()) {
                $loginData = $this->login->check_login();
                if ($loginData) {
                    $this->login->generate_session($loginData);
                    $this->adminlog->add($this->agent->browser(), $this->agent->version(), $this->agent->platform(), $this->agent->mobile());
                    $this->session->set_flashdata('adminLoginSuccess', 'Login has been Create successfully');
                    redirect($this->config->item('adminFolder') . '/dashboard');
                    exit;
                } else {
                    $this->session->set_flashdata('errormsg', 'Invalid Login Details');
                    redirect($this->config->item('adminFolder') . '/login');
                }
            }
        }
        $data['authentication_failed'] = show_message($this->lang->line('ACCESS_DENIED_FAILED'), 'danger');
        $this->load->view($this->config->item('adminFolder') . '/login');
    }

    public function forgotPassword() {
        if (!empty($_POST)) {
            $output['email'] = trim($this->input->post('email'));
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            if ($this->form_validation->run()) {
                $checkEmail = $this->login->checkEmail($this->input->post('email'));
                $adminId = $checkEmail->id;
                if ($checkEmail->email == $this->input->post('email')) {
                    $this->login->forgotPassword();
                    $returnPassword = $this->mailsending->forgotPasswordEmail($checkEmail, $adminId);
                    $this->session->set_flashdata('SUCCESS_MESSAGE', 'Please Check your mail for reset Your Password.');
                    redirect($this->config->item('adminFolder') . '/login');
                } else {
                    $output['is_error'] = 'Email invalid you have entered';
                }
            }
        }
        $this->load->view($this->config->item('adminFolder') . '/forgot_password', $output);
    }

    public function validate($token) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('new_password', 'new password', 'trim|required');
            $this->form_validation->set_rules('confirm_password', 'confirm password', 'trim|required|matches[new_password]');
            if ($this->form_validation->run()) {
                $this->login->ResetPassword($token);
                $this->session->set_flashdata('SuccessMessage', 'You Have Successfully Registered With Us');
                redirect($this->config->item('adminFolder') . '/login');
                exit();
            } else {
                $data['new_password'] = $this->input->post('new_password');
                $data['confirm_password'] = $this->input->post('confirm_password');
            }
        } else {
            $this->session->set_flashdata('errormsg', 'There Is Some Error');
        }
        $this->load->view($this->config->item('adminFolder') . '/reset_password');
    }

}