<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Icons extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/icon_model', 'icon');
        $this->load->model($this->config->item('adminFolder') . '/city_model', 'city');
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['icon_data'] = $this->icon->getIconList();

        $data['page_name'] = 'icon';
        $data['breadcum'] = 'Manage Icon';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/icon/icon_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() { 

        if (!empty($_POST)) {          
            $this->form_validation->set_rules('icon_title', 'Icon Title', 'trim|required');
            if ($_FILES["icon_image"]['name'] == '')
                $this->form_validation->set_rules('icon_image', 'Icon Image', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('region_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["icon_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/icon_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('icon_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->icon->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('IconSuccess', 'Icon Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/icon-list');
                exit;
            }else{
                    $data['icon_title']  = $this->input->post('icon_title');              
                    $data['icon_image'] = $this->input->post('icon_image');                  
                    $data['country_id'] = $this->input->post('country_id');
                    $data['region_id'] = $this->input->post('region_id');
            }
        }
            $data['page_name'] = 'icon';
            $data['breadcum'] = 'Add Icon';
            $data['country_list'] = $this->city->getCountryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/icon/icon_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($iconId) {
        
        if (!empty($_POST)) {       
            $this->form_validation->set_rules('icon_title', 'Icon Title', 'trim|required');         
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('region_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["icon_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/icon_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('icon_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->icon->update($iconId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('IconSuccess', 'Icon Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/icon-list');
                exit;
            }else{ 
                    $data['icon_title'] = $this->input->post('icon_title');            
                    $data['icon_image'] = $this->input->post('icon_image');                   
                    $data['country_id'] = $this->input->post('country_id');
                    $data['region_id'] = $this->input->post('region_id');
                }
        }
            $lists = $this->icon->getIconListById($iconId);
                $data['country_id'] = $country_id = $lists['country_id'];
                $data['country_list'] = $this->city->getCountryList();
                $data['region_list'] = $this->city->getRegionByCountry($country_id);

                $data['icon_id'] = $lists['icon_id'];
                $data['icon_title'] = $lists['icon_title'];         
                $data['icon_image'] = $lists['icon_image'];              
                $data['country_id'] = $lists['country_id'];
                $data['region_id'] = $lists['region_id'];     
            $data['page_name'] = 'icon'; 
            $data['breadcum_edit'] = 'Edit Icon';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/icon/icon_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($iconId, $status) {
        if ($iconId != '') {
             $this->icon->updateStatus($iconId, $status);
            $this->session->set_flashdata('IconSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/icon-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/icon/icon_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($iconId) {
        $icon_image_name = $this->common_model->getSingleFieldFromAnyTable('icon_image','icon_id',$iconId,$this->icon->tableName); 
        if (isset($iconId) && $iconId != '') {
            unlink('assets/uploads/icon_images/' . $icon_image_name);
            $this->icon->delete($iconId);
            $this->session->set_flashdata('IconSuccess', 'Icon Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/icon-list');
            exit;
        }
    }

}