<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Header_Link extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/header_link_model', 'header');  
        $this->load->library('form_validation');        
    }

    public function index() {       
        $data['header_data'] = $this->header->getHeaderLinkList();   
        $data['breadcum'] = 'Manage Header Link';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/header_link/header_link_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {      
            $this->form_validation->set_rules('link_title', 'Link Title', 'trim|required');
            $this->form_validation->set_rules('link_url', 'Link url', 'trim|required');
            $this->form_validation->set_rules('header_order', 'Header Order', 'trim|required');
        
            if ($this->form_validation->run()) {
                $this->header->addHeaderLink();
                $this->session->set_flashdata('HeaderLinkSuccess', 'Header Link Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/header-link-list');
                exit;
            } else {
                $data['link_title'] = $this->input->post('link_title');
                $data['link_url'] = $this->input->post('link_url');
                $data['parent_header'] = $this->input->post('parent_header');                          
                $data['header_order'] = $this->input->post('header_order');                          
            }
        } else {
            $data['parent_list'] = $this->header->getParentPageRecords();
        }
        $data['page_name'] = 'pageheader';
        $data['breadcum'] = 'Add Header Link';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/header_link/header_link_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($headerId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('link_title', 'Link Title', 'trim|required');
            $this->form_validation->set_rules('link_url', 'Link url', 'trim|required');
            $this->form_validation->set_rules('header_order', 'Header Order', 'trim|required');
            if ($this->form_validation->run()) {
                
                $this->header->updateHeaderLink($headerId);
                $this->session->set_flashdata('HeaderLinkSuccess', 'Header Link Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/header-link-list');
                exit;
            } else {
                $data['link_title'] = $this->input->post('link_title');
                $data['link_url'] = $this->input->post('link_url');
                $data['parent_header'] = $this->input->post('parent_header');   
                $data['header_order'] = $this->input->post('header_order');   
            }
        }else{         
            $lists = $this->header->getHeaderLinksById($headerId);
            $data['header_link_id'] = $lists['header_link_id'];
            $data['link_title'] = $lists['link_title'];
            $data['link_url'] = $lists['link_url']; 
            $data['parent_header'] = $lists['parent_header'];
            $data['header_order'] = $lists['header_order']; 
        }    
        $data['breadcum_edit'] = 'Edit Header Link';
        $data['parent_list'] = $this->header->getParentPageRecords();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/header_link/header_link_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($headerId, $action) {
        if ($headerId != '') {
            $data = $this->header->updateStatus($headerId, $action);
            $this->session->set_flashdata('HeaderLinkSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/header-link-list');
            exit;
        }
    }

    public function delete($headerId) {
        if (isset($headerId) && $headerId != '') {
            $this->header->delete($headerId);
            $this->session->set_flashdata('HeaderLinkSuccess', 'Header Link Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/header-link-list');
            exit;
        }
    }

}