<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Footer_Link extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/footer_link_model', 'footer');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['footer_data'] = $this->footer->getFooterLinkList();
        $data['breadcum'] = 'Manage Footer Link';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/footer_link/footer_link_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('link_title', 'Link Title', 'trim|required');
            $this->form_validation->set_rules('link_url', 'Link url', 'trim|required');
            $this->form_validation->set_rules('footer_order', 'Footer Order', 'trim|required');

            if ($this->form_validation->run()) {
                $this->footer->addFooterLink();
                $this->session->set_flashdata('FooterLinkSuccess', 'Footer Link Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/footer-link-list');
                exit;
            } else {
                $data['link_title'] = $this->input->post('link_title');
                $data['link_url'] = $this->input->post('link_url');
                $data['parent_footer'] = $this->input->post('parent_footer');
                $data['footer_order'] = $this->input->post('footer_order');
            }
        }
        $data['parent_list'] = $this->footer->getParentPageRecords();
        $data['breadcum'] = 'Add Footer Link';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/footer_link/footer_link_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($footerId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('link_title', 'Link Title', 'trim|required');
            $this->form_validation->set_rules('link_url', 'Link url', 'trim|required');
            $this->form_validation->set_rules('footer_order', 'Footer Order', 'trim|required');
            if ($this->form_validation->run()) {
                $this->footer->updateFooterLink($footerId);
                $this->session->set_flashdata('FooterLinkSuccess', 'Footer Link Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/footer-link-list');
                exit;
            } else {
                $data['link_title'] = $this->input->post('link_title');
                $data['link_url'] = $this->input->post('link_url');
                $data['parent_footer'] = $this->input->post('parent_footer');
                $data['footer_order'] = $this->input->post('footer_order');
            }
        } else {
            $lists = $this->footer->getFooterLinksById($footerId);
            $data['footer_link_id'] = $lists['footer_link_id'];
            $data['link_title'] = $lists['link_title'];
            $data['link_url'] = $lists['link_url'];
            $data['parent_footer'] = $lists['parent_footer'];
            $data['footer_order'] = $lists['footer_order'];
        }
        $data['breadcum'] = 'Edit Footer Link';
        $data['parent_list'] = $this->footer->getParentPageRecords();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/footer_link/footer_link_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($footerId, $action) {
        if ($footerId != '') {
            $data = $this->footer->updateStatus($footerId, $action);
            $this->session->set_flashdata('FooterLinkSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/footer-link-list');
            exit;
        }
    }

    public function delete($footerId) {
        if (isset($footerId) && $footerId != '') {
            $this->footer->delete($footerId);
            $this->session->set_flashdata('FooterLinkSuccess', 'Footer Link Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/footer-link-list');
            exit;
        }
    }

}