<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dashboard extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/dashboard_model');
    }

    public function index() {
        $data['page_name'] = 'dashboard';
         $data['count_total_enquiry'] = $this->dashboard_model->CountTotalEnquiry();
         $data['count_total_location'] = $this->dashboard_model->CountTotalLocation();
         $data['count_total_coupon'] = $this->dashboard_model->CountTotalCoupon();
         $data['count_total_order'] = $this->dashboard_model->CountTotalOrders();
         $data['total_pending_order'] = $this->dashboard_model->TotalPendingOrder();
         $data['total_cancelled_order'] = $this->dashboard_model->TotalCancelledOrder();
         $data['total_completed_order'] = $this->dashboard_model->TotalCompletedOrder();         
         $data['total_static_pages'] = $this->dashboard_model->TotalStaticPages();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/dashboard');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

}