<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Country extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/country_model', 'country');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['country_data'] = $this->country->getCountryList();
        $data['page_name'] = 'Countries';
        $data['breadcum'] = 'Manage Country';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/country/country_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $country_name = $this->input->post('country_name');
            $this->form_validation->set_rules('code', 'Country Code', 'trim|required');
            $this->form_validation->set_rules('country_name', 'Country Name', 'trim|required');
            $this->form_validation->set_rules('currency_name', 'Currency Name', 'trim|required');
            if ($_FILES["image"]['name'] == '')
                $this->form_validation->set_rules('image', 'Country Image', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["image"]['name']) {
                    $config['upload_path'] = './assets/uploads/country_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->country->add($country_name, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('CountrySuccess', 'Country Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/country-list');
                exit;
            } else {
                $data['code'] = $this->input->post('code');
                $data['country_name'] = $this->input->post('country_name');
                $data['currency_name'] = $this->input->post('currency_name');
                $data['image'] = $this->input->post('image');
            }
        }
        $data['page_name'] = 'Countries';
        $data['breadcum'] = 'Add Country';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/country/country_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($countryId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('code', 'Country Code', 'trim|required');
            $this->form_validation->set_rules('country_name', 'Country Name', 'trim|required');
            $this->form_validation->set_rules('currency_name', 'Currency Name', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["image"]['name']) {
                    $config['upload_path'] = './assets/uploads/country_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->country->update($countryId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('CountrySuccess', 'Country Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/country-list');
                exit;
            } else {
                $data['code'] = $this->input->post('code');
                $data['country_name'] = $this->input->post('country_name');
                $data['currency_name'] = $this->input->post('currency_name');
                $data['image'] = $this->input->post('image');
            }
        } else {
            $lists = $this->country->getCountryListById($countryId);
            $data['country_id'] = $countryId;
            $data['code'] = $lists['code'];
            $data['country_name'] = $lists['country_name'];
            $data['currency_name'] = $lists['currency_name'];
            $data['image'] = $lists['image'];
        }
        $data['page_name'] = 'Countries';
        $data['breadcum_edit'] = 'Edit Country';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/country/country_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($countryId, $status) {
        if ($countryId != '') {
            $this->country->updateStatus($countryId, $status);
            $this->session->set_flashdata('CountrySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/country-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/country/country_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($countryId) {
        $filename = $this->country->getFileName($countryId);
        $country_image = $filename['image'];
        if (isset($countryId) && $countryId != '') {
            unlink('assets/uploads/country_images/' . $country_image);
            $this->country->delete($countryId);
            $this->session->set_flashdata('CountrySuccess', 'Country Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/country-list');
            exit;
        }
    }

}