<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class City extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/city_model', 'city');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['city_data'] = $this->city->getCityList();
        $data['page_name'] = 'Cities';
        $data['breadcum'] = 'Manage City';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/city/city_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function getRegionList() {
        $country_id = $this->input->post('country_id');
        $data['region_list'] = $region_list = $this->city->getRegionByCountry($country_id);
        echo json_encode($region_list);
        die;
    }

    public function add() {
        if (!empty($_POST)) {
            $city_name = $this->input->post('city_name');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('region_id', 'Region', 'trim|required');
            $this->form_validation->set_rules('city_name', 'City Name', 'trim|required');

            if ($this->form_validation->run()) {
                $this->city->add($city_name);
                $this->session->set_flashdata('CitySuccess', 'City Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/city-list');
                exit;
            } else {
                $data['country_id'] = $this->input->post('country_id');
                $data['region_id'] = $this->input->post('region_id');
                $data['city_name'] = $this->input->post('city_name');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
            }
        } else {
            $data['country_list'] = $this->city->getCountryList();
            $data['page_name'] = 'Cities';
            $data['breadcum'] = 'Add City';
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/city/city_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($cityId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('region_id', 'Region', 'trim|required');
            $this->form_validation->set_rules('city_name', 'City Name', 'trim|required');

            if ($this->form_validation->run()) {
                $this->city->update($cityId);
                $this->session->set_flashdata('CitySuccess', 'City Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/city-list');
                exit;
            } else {
                $data['country_id'] = $this->input->post('country_id');
                $data['region_id'] = $this->input->post('region_id');
                $data['city_name'] = $this->input->post('city_name');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
            }
        } else {
            $data['lists'] = $lists = $this->city->getCityListById($cityId);
            $data['country_id'] = $country_id = $lists['country_id'];
            $data['country_list'] = $this->city->getCountryList();
            $data['region_list'] = $region_list = $this->city->getRegionByCountry($country_id);
            $data['city_id'] = $cityId;
            $data['region_id'] = $lists['region_id'];
            $data['city_name'] = $lists['city_name'];
            $data['meta_title'] = $lists['meta_title'];
            $data['meta_keywords'] = $lists['meta_keywords'];
            $data['meta_description'] = $lists['meta_description'];
        }
        $data['page_name'] = 'Cities';
        $data['breadcum_edit'] = 'Edit City';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/city/city_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($cityId, $action) {
        if ($cityId != '') {
            $countryData = $this->city->updateStatus($cityId, $action);
            $this->session->set_flashdata('CitySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/city-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/city/city_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($cityId) {
        if (isset($cityId) && $cityId != '') {
            $this->city->delete($cityId);
            $this->session->set_flashdata('CitySuccess', 'City Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/city-list');
            exit;
        }
    }

    public function getCityList() {
        $region_id = $this->input->post('region_id');
        $data['city_list'] = $city_list = $this->city->getCityByRegion($region_id);
        $data['success'] = true;
        if (sizeof($city_list) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }

}