<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Banner extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/banner_model', 'banner');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['banner_data'] = $this->banner->getBannerList();

        $data['breadcum'] = 'Manage Banner';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/banner/banner_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() { 

        if (!empty($_POST)) {          
            $this->form_validation->set_rules('banner_title', 'Banner Title', 'trim|required');
            if ($_FILES["banner_image"]['name'] == '')
                $this->form_validation->set_rules('banner_image', 'Banner Image', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["banner_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/banner_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('banner_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->banner->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('BannerSuccess', 'Banner Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/banner-list');
                exit;
            }else{
                    $data['banner_title']  = $this->input->post('banner_title');              
                    $data['banner_image'] = $this->input->post('banner_image');                  
                    $data['banner_text'] = $this->input->post('banner_text');                  
                    $data['country_id'] = $this->input->post('country_id');
                    $data['province_id'] = $this->input->post('province_id');
            }
        }
            
            $data['breadcum'] = 'Add Banner';
            $data['country_list'] = $this->country->getCountryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/banner/banner_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($bannerId) {
        
        if (!empty($_POST)) {          
            $this->form_validation->set_rules('banner_title', 'Banner Title', 'trim|required');         
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["banner_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/banner_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('banner_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->banner->update($bannerId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('BannerSuccess', 'Banner Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/banner-list');
                exit;
            }else{ 
                    $data['banner_title'] = $this->input->post('banner_title');            
                    $data['banner_image'] = $this->input->post('banner_image');                   
                    $data['banner_text'] = $this->input->post('banner_text');                   
                    $data['country_id'] = $this->input->post('country_id');
                    $data['province_id'] = $this->input->post('province_id');
                }
        }
            $lists = $this->banner->getBannerListById($bannerId);
                $data['country_id'] = $country_id = $lists['country_id'];
                $data['country_list'] = $this->country->getCountryList();         
                $data['province_list'] = $this->province->getProvinceListByCountry($country_id);  

                $data['banner_id'] = $lists['banner_id'];
                $data['banner_title'] = $lists['banner_title'];         
                $data['banner_image'] = $lists['banner_image'];              
                $data['banner_text'] = $lists['banner_text'];  
                $data['province_id'] = $lists['province_id'];   
            $data['breadcum_edit'] = 'Edit Banner';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/banner/banner_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($bannerId, $status) {
        if ($bannerId != '') {
             $this->banner->updateStatus($bannerId, $status);
            $this->session->set_flashdata('BannerSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/banner-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);        
        $this->load->view($this->config->item('adminFolder') . '/banner/banner_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($bannerId) {
        $banner_image_name = $this->common_model->getSingleFieldFromAnyTable('banner_image','banner_id',$bannerId,$this->banner->tableName); 
        if (isset($bannerId) && $bannerId != '') {
            unlink('assets/uploads/banner_images/' . $banner_image_name);
            $this->banner->delete($bannerId);
            $this->session->set_flashdata('BannerSuccess', 'Banner Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/banner-list');
            exit;
        }
    }

}