<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Admin extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/admin_model', 'admin');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
        $this->load->library('form_validation');        
    }  

    public function index() {
        $data['admin_data'] = $this->admin->getAdminRecords();    
        $data['breadcum'] = 'Manage Admin';
        
        $this->load->view($this->config->item('adminFolder').'/header', $data);      
        $this->load->view($this->config->item('adminFolder').'/admin/admin_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function add() {           
        if (!empty($_POST)) {
        
           if($_FILES["icon_image"]['name'] == '')
                $this->form_validation->set_rules('icon_image', 'Image', 'trim|required');
            $this->form_validation->set_rules('username', 'User Name', 'trim|required|is_unique[tbl_admin.username]');
            $this->form_validation->set_rules('password', 'Password', 'trim|required');
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|is_unique[tbl_admin.email]');
            $this->form_validation->set_rules('department', 'Department', 'trim|required');          
         

            if ($this->form_validation->run()) {
                 if ($_FILES["icon_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/icon_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('icon_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->admin->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('AdminSuccess','Admin Has Been Added Successfully');
                redirect($this->config->item('adminFolder').'/admin-list');
                exit;
            }else{
                    $data['username'] = $this->input->post('username');
                    $data['password'] = $this->input->post('password');
                    $data['phone'] = $this->input->post('phone');
                    $data['email'] = $this->input->post('email');
                    $data['department'] = $this->input->post('department');
                    $data['country_id'] = $this->input->post('country_id');
                    $data['province_id'] = $this->input->post('province_id');
                    $data['icon_image'] = $this->input->post('icon_image');
            }
        }
       
            $data['breadcum'] = 'Add Admin';
            $data['country_list'] = $this->country->getCountryList();
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/admin/admin_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function edit($adminId) { 
        if (!empty($_POST)) {
            
            $email = $this->input->post('email');
            $default_email = $this->admin->checkEmail($adminId);
            $email_address = $default_email['email'];
            if($email_address != $email){
            $this->form_validation->set_rules('email', 'Email', 'trim|required|is_unique[tbl_admin.email]');
            }
            $this->form_validation->set_rules('phone', 'Phone', 'trim|required');
            $this->form_validation->set_rules('department', 'Department', 'trim|required');

            if ($this->form_validation->run()) {
                  if ($_FILES["icon_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/icon_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('icon_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->admin->update($adminId,$detail['upload_data']['file_name']);
                $this->session->set_flashdata('AdminSuccess','Admin Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/admin-list');
                exit;
            }else{
                    $data['phone'] = $this->input->post('phone');
                    $data['email'] = $this->input->post('email');
                    $data['department'] = $this->input->post('department');
                    $data['country_id'] = $this->input->post('country_id');
                    $data['province_id'] = $this->input->post('province_id');
                    $data['icon_image'] = $this->input->post('icon_image');  
            }
        }
        $lists = $this->admin->getAdminRecordById($adminId);  
                $data['admin_id'] = $adminId;  
                $data['email'] = $lists['email'];
                $data['phone'] = $lists['phone'];
                $data['department'] = $lists['department'];   
                $data['country_id'] = $country_id = $lists['country_id'];
                $data['province_id']  = $lists['province_id'];       
                $data['icon_image'] = $lists['icon_image'];     
                $data['country_list'] = $this->country->getCountryList();         
                $data['province_list'] = $this->province->getProvinceListByCountry($country_id);  

                $data['page_name'] = 'adminData';
                $data['breadcum_edit'] = 'Edit Admin'; 
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/admin/admin_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function approve($adminId, $status) {
          $totalAdmins = $this->admin->countAllAdmin(); 
           if ($totalAdmins != '1' || $status == 'active') {
            $this->admin->updateStatus($adminId, $status);
            $this->session->set_flashdata('AdminSuccess','Status Of This Record Has Been Updated Successfully');     
            redirect($this->config->item('adminFolder').'/admin-list');
            exit;
        }
        else{
             $this->session->set_flashdata('AdminError','You can not change status of this record');      
            redirect($this->config->item('adminFolder').'/admin-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/admin/admin_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function delete($adminId) {
        $totalAdmins = $this->admin->countAllAdmin();
        $image = $this->admin->getFileName($adminId);
        $image_name = $image['icon_image'];
        if ($totalAdmins != '1') {
            unlink('assets/uploads/icon_images/'.$image_name);
            $this->admin->delete($adminId);
            $this->session->set_flashdata('AdminSuccess','Admin Has Been Deleted Successfully');     
            redirect($this->config->item('adminFolder').'/admin-list');
            exit;
        }
        else{
            $this->session->set_flashdata('AdminError','You can not delete this admin record!');     
            redirect($this->config->item('adminFolder').'/admin-list');
            exit;
        }
    }

}