<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "welcome";
$route['404_override'] = '';

$route['uploads/(:any)/(:any)'] 	= "image/resize/";
//$route['uploads/(:any)/(:any)/(:any)'] 	= "image/resize/";
//$route['uploads/(:any)/(:any)/(:any)/(:any)'] 	= "image/resize/";

//======= Front End Page ===============//

$route['inquiry'] = 'enquiry/index';
$route['getContactUs'] = 'welcome/getContactUs';
$route['subscriber-add'] = 'welcome/subscribe_add';
$route['menu'] = 'menu/index';



//location Controller
$route['copyright/(:any)'] = 'locations/locationCopyright/$1';
$route['select-your-location'] = 'landing/user_location';
$route['location'] = 'locations/index';
$route['location/(:any)'] = 'locations/locationDetail/$1';
$route['change_location'] = "locations/set_user_location";
$route['change-location/(:num)'] = 'locations/changeLocation/$1';
$route['gallery/(:any)'] = 'locations/province_gallery/$1';

$route['order-by-tray'] = 'catering/index';

$route['online-order'] = 'catering/online_order';
$route['online-order/meals'] = 'meals/index';
$route['catering'] = 'catering/index';
$route['catering/getItemsData/(:any)'] = 'catering/getItemsData/$1';
$route['order-by-tray/(:any)'] = 'catering/itemByCategory/$1';
$route['online-order/(:any)'] = 'catering/online_order_items/$1';
$route['order-by-tray-item/(:any)'] = 'catering/itemByItemSlug/$1';
$route['catering/(:any)'] = 'catering/itemByCategory/$1';
$route['add_to_cart'] = 'cart/addCartItem';
$route['add_online_item_to_cart'] = 'cart/addCartOnlineItem';
$route['add-cart-package-item'] = 'cart/addCartPackageItem';
$route['add-cart-meal-item'] = 'cart/addCartMealItem';
$route['apply-coupon'] = 'cart/applyCoupon';
$route['delete-cart-item'] = 'cart/deleteCartItem';
$route['get-cart-package-items/(:num)'] = 'cart/getCartPackageItems/$1';
$route['order-confirmation'] = 'order/index';
$route['order-complete'] = 'order/finalization';
$route['order-status'] = 'thanks/updateOrderStatus';
$route['cancel-order'] = 'order/cancilOrder';
$route['empty-cart'] = 'cart/emptyCart';
$route['thanks-for-order'] = 'thanks/index';
$route['configure-package/(:num)'] = 'package/configurePackage/$1';
$route['security/image_refresh'] = "welcome/register_security_code_refresh";

$route['increment-product'] = 'cart/incrementProductQuantity';
$route['decrement-product'] = 'cart/decrementProductQuantity';
$route['cart'] = 'cart/index';
$route['checkout'] = 'cart/checkout';
$route['package'] = 'package/index';
$route['package-detail/(:num)/(:num)'] = 'package/getPackgeDetail/$1/$2';
$route['meals'] = 'meals/index';
$route['meals-detail/(:num)'] = 'meals/getPackgeDetail/$1';
$route['get-meals-by-category'] = 'meals/getMealsByCategory';
$route['ajax-area-charge'] = 'cart/getAreaCharges';
$route['blog'] = 'blog/index';
$route['blog/(:any)'] = 'blog/blogdetail/$1';
$route['blogAdded/(:any)'] = 'blog/added/$1';
$route['blog-category/(:any)'] = 'blog/blogCategory/$1';
$route['blog-archive/(:any)'] = 'blog/blogArchive/$1';
$route['payment-failure'] = 'thanks/paypal_failure';
$route['payment-success'] = 'thanks/paypal_success';
$route['validate-paypal'] = 'thanks/validatePaypal';
//======= Admin Related Urls===================//

$route['admin'] = 'admin/login/index';
$route['admin/login'] = 'admin/login/index';
$route['admin/logout'] = 'admin/logout/index';
$route['admin/dashboard'] = 'admin/dashboard/index';
$route['forgotPassword/validate/(:any)'] = 'admin/login/validate/$1';

$route['admin/admin-list'] = 'admin/admin/index';
$route['admin/admin-add'] = 'admin/admin/add';
$route['admin/admin-edit/(:num)'] = 'admin/admin/edit/$1';
$route['admin/admin-delete/(:num)'] = 'admin/admin/delete/$1';
$route['admin/admin-status/(:num)/(:any)'] = 'admin/admin/approve/$1/$2';

$route['admin/copy-location'] = 'admin/copy_location/index';

$route['admin/adminlog-list'] = 'admin/adminlog/index';
$route['admin/adminlog-delete'] = 'admin/adminlog/delete';
$route['admin/website-links'] = 'admin/website/index';

$route['admin/banner-list'] = 'admin/banner/index';
$route['admin/banner-add'] = 'admin/banner/add';
$route['admin/banner-edit/(:num)'] = 'admin/banner/edit/$1';
$route['admin/banner-delete/(:num)'] = 'admin/banner/delete/$1';
$route['admin/banner-status/(:num)/(:any)'] = 'admin/banner/approve/$1/$2';

$route['admin/coupon-list'] = 'admin/coupon/index';
$route['admin/coupon-add'] = 'admin/coupon/add';
$route['admin/coupon-edit/(:num)'] = 'admin/coupon/edit/$1';
$route['admin/coupon-delete/(:num)'] = 'admin/coupon/delete/$1';
$route['admin/coupon-status/(:num)/(:any)'] = 'admin/coupon/approve/$1/$2';

$route['admin/area-list'] = 'admin/delivery_charge/index';
$route['admin/area-add'] = 'admin/delivery_charge/add';
$route['admin/area-edit/(:num)'] = 'admin/delivery_charge/edit/$1';
$route['admin/area-delete/(:num)'] = 'admin/delivery_charge/delete/$1';
$route['admin/area-status/(:num)/(:any)'] = 'admin/delivery_charge/approve/$1/$2';

$route['admin/icon-list'] = 'admin/icons/index';
$route['admin/icon-add'] = 'admin/icons/add';
$route['admin/icon-edit/(:num)'] = 'admin/icons/edit/$1';
$route['admin/icon-delete/(:num)'] = 'admin/icons/delete/$1';
$route['admin/icon-status/(:num)/(:any)'] = 'admin/icons/approve/$1/$2';

$route['admin/email-template-list'] = 'admin/email_template/index';
$route['admin/email-template-add'] = 'admin/email_template/add';
$route['admin/email-template-edit/(:num)'] = 'admin/email_template/edit/$1';
$route['admin/email-template-delete/(:num)'] = 'admin/email_template/delete/$1';
$route['admin/email-template-status/(:num)/(:any)'] = 'admin/email_template/approve/$1/$2';

$route['admin/testimonial-list'] = 'admin/testimonial/index';
$route['admin/testimonial-add'] = 'admin/testimonial/add';
$route['admin/testimonial-edit/(:num)'] = 'admin/testimonial/edit/$1';
$route['admin/testimonial-delete/(:num)'] = 'admin/testimonial/delete/$1';
$route['admin/testimonial-status/(:num)/(:any)'] = 'admin/testimonial/approve/$1/$2';

$route['admin/promotional-banner-list'] = 'admin/sidebanner/index';
$route['admin/promotional-banner-add'] = 'admin/sidebanner/add';
$route['admin/promotional-banner-edit/(:num)'] = 'admin/sidebanner/edit/$1';
$route['admin/promotional-banner-delete/(:num)'] = 'admin/sidebanner/delete/$1';
$route['admin/promotional-banner-status/(:num)/(:any)'] = 'admin/sidebanner/approve/$1/$2';

$route['admin/newsletter-list'] = 'admin/newsletter/index';
$route['admin/newsletter-add'] = 'admin/newsletter/add';
$route['admin/newsletter-edit/(:num)'] = 'admin/newsletter/edit/$1';
$route['admin/newsletter-view/(:num)'] = 'admin/newsletter/view/$1';
$route['admin/newsletter-send/(:num)/(:any)'] = 'admin/newsletter/send_newsletter/$1/$2';
$route['admin/newsletter-delete/(:num)'] = 'admin/newsletter/delete/$1';
$route['admin/newsletter-status/(:num)/(:any)'] = 'admin/newsletter/approve/$1/$2';

$route['admin/enquiry-list'] = 'admin/enquiry/index';
$route['admin/enquiry-view/(:num)'] = 'admin/enquiry/view/$1';
$route['admin/enquiry-delete/(:num)'] = 'admin/enquiry/delete/$1';

$route['admin/header-link-list'] = 'admin/header_link/index';
$route['admin/header-link-add'] = 'admin/header_link/add';
$route['admin/header-link-edit/(:num)'] = 'admin/header_link/edit/$1';
$route['admin/header-link-delete/(:num)'] = 'admin/header_link/delete/$1';
$route['admin/header-link-status/(:num)/(:any)'] = 'admin/header_link/approve/$1/$2';

$route['admin/footer-link-list'] = 'admin/footer_link/index';
$route['admin/footer-link-add'] = 'admin/footer_link/add';
$route['admin/footer-link-edit/(:num)'] = 'admin/footer_link/edit/$1';
$route['admin/footer-link-delete/(:num)'] = 'admin/footer_link/delete/$1';
$route['admin/footer-link-status/(:num)/(:any)'] = 'admin/footer_link/approve/$1/$2';

$route['admin/meta-tag-list'] = 'admin/meta_tag/index';
$route['admin/meta-tag-add'] = 'admin/meta_tag/add';
$route['admin/meta-tag-edit/(:num)'] = 'admin/meta_tag/edit/$1';
$route['admin/meta-tag-delete/(:num)'] = 'admin/meta_tag/delete/$1';
$route['admin/meta-tag-status/(:num)/(:any)'] = 'admin/meta_tag/approve/$1/$2';

$route['admin/order-list'] = 'admin/order/index';
$route['admin/order-view/(:num)'] = 'admin/order/view/$1';
$route['admin/order-delete/(:num)'] = 'admin/order/delete/$1';
$route['admin/order-status/(:num)/(:any)'] = 'admin/order/approve/$1/$2';

$route['admin/menu-category-list'] = 'admin/menu_category/index';
$route['admin/menu-category-add'] = 'admin/menu_category/add';
$route['admin/menu-category-edit/(:num)'] = 'admin/menu_category/edit/$1';
$route['admin/menu-category-delete/(:num)'] = 'admin/menu_category/delete/$1';
$route['admin/menu-category-status/(:num)/(:any)'] = 'admin/menu_category/approve/$1/$2';

$route['admin/menu-item-list'] = 'admin/menu_item/index';
$route['admin/menu-item-add'] = 'admin/menu_item/add';
$route['admin/menu-item-edit/(:num)'] = 'admin/menu_item/edit/$1';
$route['admin/menu-item-delete/(:num)'] = 'admin/menu_item/delete/$1';
$route['admin/menu-unit-specification/(:num)'] = 'admin/menu_item/menuUnitSpecifications/$1';
$route['admin/menu-item-status/(:num)/(:any)'] = 'admin/menu_item/approve/$1/$2';

$route['admin/newsletter-list'] = 'admin/newsletter/index';
$route['admin/newsletter-add'] = 'admin/newsletter/add';
$route['admin/newsletter-edit/(:num)'] = 'admin/newsletter/edit/$1';
$route['admin/newsletter-view/(:num)'] = 'admin/newsletter/view/$1';
$route['admin/newsletter-send/(:num)'] = 'admin/newsletter/send_newsletter/$1';
$route['admin/newsletter-delete/(:num)'] = 'admin/newsletter/delete/$1';
$route['admin/newsletter-status/(:num)/(:any)'] = 'admin/newsletter/approve/$1/$2';

$route['admin/tray-category-list'] = 'admin/tray_category/index';
$route['admin/tray-category-add'] = 'admin/tray_category/add';
$route['admin/tray-category-edit/(:num)'] = 'admin/tray_category/edit/$1';
$route['admin/tray-category-delete/(:num)'] = 'admin/tray_category/delete/$1';
$route['admin/tray-category-status/(:num)/(:any)'] = 'admin/tray_category/approve/$1/$2';

$route['admin/tray-item-list'] = 'admin/tray_item/index';
$route['admin/tray-item-add'] = 'admin/tray_item/add';
$route['admin/tray-item-edit/(:num)'] = 'admin/tray_item/edit/$1';
$route['admin/tray-item-delete/(:num)'] = 'admin/tray_item/delete/$1';
$route['admin/tray-item-status/(:num)/(:any)'] = 'admin/tray_item/approve/$1/$2';
$route['admin/unit-specification/(:num)'] = 'admin/tray_item/unitSpecifications/$1';
$route['admin/ajax-category-list'] = 'admin/tray_item/getCategoryList';

$route['admin/online-category-list'] = 'admin/online_category/index';
$route['admin/online-category-add'] = 'admin/online_category/add';
$route['admin/online-category-edit/(:num)'] = 'admin/online_category/edit/$1';
$route['admin/online-category-delete/(:num)'] = 'admin/online_category/delete/$1';
$route['admin/online-category-status/(:num)/(:any)'] = 'admin/online_category/approve/$1/$2';

$route['admin/online-item-list'] = 'admin/online_item/index';
$route['admin/online-item-add'] = 'admin/online_item/add';
$route['admin/online-item-edit/(:num)'] = 'admin/online_item/edit/$1';
$route['admin/online-item-delete/(:num)'] = 'admin/online_item/delete/$1';
$route['admin/online-item-status/(:num)/(:any)'] = 'admin/online_item/approve/$1/$2';
$route['admin/online-unit-specification/(:num)'] = 'admin/online_item/unitSpecifications/$1';



$route['admin/package-category-list'] = 'admin/package_category/index';
$route['admin/package-category-add'] = 'admin/package_category/add';
$route['admin/package-category-edit/(:num)'] = 'admin/package_category/edit/$1';
$route['admin/package-category-delete/(:num)'] = 'admin/package_category/delete/$1';
$route['admin/package-category-status/(:num)/(:any)'] = 'admin/package_category/approve/$1/$2';

$route['admin/package-item-list'] = 'admin/package_item/index';
$route['admin/package-item-add'] = 'admin/package_item/add';
$route['admin/package-item-edit/(:num)'] = 'admin/package_item/edit/$1';
$route['admin/package-item-delete/(:num)'] = 'admin/package_item/delete/$1';
$route['admin/package-item-status/(:num)/(:any)'] = 'admin/package_item/approve/$1/$2';

$route['admin/package-list'] = 'admin/package/index';
$route['admin/package-add'] = 'admin/package/add';
$route['admin/package-edit/(:num)'] = 'admin/package/edit/$1';
$route['admin/ajax-package-item-list'] = 'admin/package/getPackageItemList';
$route['admin/package-delete/(:num)'] = 'admin/package/delete/$1';
$route['admin/package-specification-delete/(:num)/(:num)'] = 'admin/package/deleteSpecification/$1/$2';
$route['admin/package-status/(:num)/(:any)'] = 'admin/package/approve/$1/$2';
$route['admin/package-specification/(:num)'] = 'admin/package/packageSpecifications/$1';

$route['admin/meal-list'] = 'admin/meals/index';
$route['admin/meal-add'] = 'admin/meals/add';
$route['admin/meal-edit/(:num)'] = 'admin/meals/edit/$1';
$route['admin/ajax-meal-item-list'] = 'admin/meals/getPackageItemList';
$route['admin/meal-delete/(:num)'] = 'admin/meals/delete/$1';
$route['admin/meal-specification-delete/(:num)/(:num)'] = 'admin/meals/deleteSpecification/$1/$2';
$route['admin/meal-status/(:num)/(:any)'] = 'admin/meals/approve/$1/$2';
$route['admin/meal-specification/(:num)'] = 'admin/meals/packageSpecifications/$1';

$route['admin/content-list'] = 'admin/content/index';
$route['admin/content-add'] = 'admin/content/add';
$route['admin/content-edit/(:num)'] = 'admin/content/edit/$1';
$route['admin/content-delete/(:num)'] = 'admin/content/delete/$1';
$route['admin/content-status/(:num)/(:any)'] = 'admin/content/approve/$1/$2';

$route['admin/country-list'] = 'admin/country/index';
$route['admin/country-add'] = 'admin/country/add';
$route['admin/country-edit/(:num)'] = 'admin/country/edit/$1';
$route['admin/country-delete/(:num)'] = 'admin/country/delete/$1';
$route['admin/country-status/(:num)/(:any)'] = 'admin/country/approve/$1/$2';

$route['admin/province-list'] = 'admin/province/index';
$route['admin/province-add'] = 'admin/province/add';
$route['admin/province-edit/(:num)'] = 'admin/province/edit/$1';
$route['admin/province-delete/(:num)'] = 'admin/province/delete/$1';
$route['admin/province-status/(:num)/(:any)'] = 'admin/province/approve/$1/$2';
$route['admin/province-default-status/(:num)/(:any)'] = 'admin/province/set_language/$1/$2';
$route['admin/province-delete-image/(:num)'] = 'admin/province/deleteImage/$1';
$route['admin/province-manage-pictures/(:num)'] = 'admin/province/managePictures/$1';
$route['upload-province-images/(:num)'] = 'admin/province/uploadImages/$1';
$route['admin/set-image-order'] = 'admin/province/setImageOrder';

//$route['admin/city-list'] = 'admin/city/index';
//$route['admin/city-add'] = 'admin/city/add';
//$route['admin/city-edit/(:num)'] = 'admin/city/edit/$1';
//$route['admin/city-delete/(:num)'] = 'admin/city/delete/$1';
//$route['admin/city-status/(:num)/(:any)'] = 'admin/city/approve/$1/$2';

$route['admin/blog-list'] = 'admin/blog/index';
$route['admin/blog-add'] = 'admin/blog/add';
$route['admin/blog-edit/(:num)'] = 'admin/blog/edit/$1';
$route['admin/blog-delete/(:num)'] = 'admin/blog/delete/$1';
$route['admin/blog-status/(:num)/(:any)'] = 'admin/blog/approve/$1/$2';
$route['admin/blog-delete-image/(:num)'] = 'admin/blog/delete_image/$1';
$route['admin/blog-category-list'] = 'admin/blog_category/index';
$route['admin/blog-category-add'] = 'admin/blog_category/add';
$route['admin/blog-category-edit/(:num)'] = 'admin/blog_category/edit/$1';
$route['admin/blog-category-delete/(:num)'] = 'admin/blog_category/delete/$1';
$route['admin/blog-category-status/(:num)/(:any)'] = 'admin/blog_category/approve/$1/$2';

$route['admin/blog-comment'] = 'admin/blogcomment/commentList';
$route['admin/blog-comment/(:num)'] = 'admin/blogcomment/index/$1';
$route['admin/comment-delete/(:num)'] = 'admin/blogcomment/delete/$1';
$route['admin/comment-status/(:num)/(:any)'] = 'admin/blogcomment/approve/$1/$2';

$route['admin/ajax-province-list'] = 'admin/province/getProvinceData';
$route['admin/ajax-city-list'] = 'admin/city/getCityList';
$route['admin/forgot-password'] = 'admin/login/forgotPassword';
$route['admin/change-password'] = 'admin/change_password/index';

$route['(:any)'] = 'content/index/$1';


/* End of file routes.php */
/* Location: ./application/config/routes.php */